/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.AccountKeyType;
import java.io.IOException;

public final class BatchAccountRegenerateKeyParameters
implements JsonSerializable<BatchAccountRegenerateKeyParameters> {
    private AccountKeyType keyName;
    private static final ClientLogger LOGGER = new ClientLogger(BatchAccountRegenerateKeyParameters.class);

    public AccountKeyType keyName() {
        return this.keyName;
    }

    public BatchAccountRegenerateKeyParameters withKeyName(AccountKeyType keyName) {
        this.keyName = keyName;
        return this;
    }

    public void validate() {
        if (this.keyName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property keyName in model BatchAccountRegenerateKeyParameters"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyName", this.keyName == null ? null : this.keyName.toString());
        return jsonWriter.writeEndObject();
    }

    public static BatchAccountRegenerateKeyParameters fromJson(JsonReader jsonReader) throws IOException {
        return (BatchAccountRegenerateKeyParameters)jsonReader.readObject(reader -> {
            BatchAccountRegenerateKeyParameters deserializedBatchAccountRegenerateKeyParameters = new BatchAccountRegenerateKeyParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyName".equals(fieldName)) {
                    deserializedBatchAccountRegenerateKeyParameters.keyName = AccountKeyType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchAccountRegenerateKeyParameters;
        });
    }
}

