/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.PoolIdentityType;
import com.azure.resourcemanager.batch.models.UserAssignedIdentities;
import java.io.IOException;
import java.util.Map;

public final class BatchPoolIdentity
implements JsonSerializable<BatchPoolIdentity> {
    private PoolIdentityType type;
    private Map<String, UserAssignedIdentities> userAssignedIdentities;
    private static final ClientLogger LOGGER = new ClientLogger(BatchPoolIdentity.class);

    public PoolIdentityType type() {
        return this.type;
    }

    public BatchPoolIdentity withType(PoolIdentityType type) {
        this.type = type;
        return this;
    }

    public Map<String, UserAssignedIdentities> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public BatchPoolIdentity withUserAssignedIdentities(Map<String, UserAssignedIdentities> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model BatchPoolIdentity"));
        }
        if (this.userAssignedIdentities() != null) {
            this.userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BatchPoolIdentity fromJson(JsonReader jsonReader) throws IOException {
        return (BatchPoolIdentity)jsonReader.readObject(reader -> {
            BatchPoolIdentity deserializedBatchPoolIdentity = new BatchPoolIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedBatchPoolIdentity.type = PoolIdentityType.fromString(reader.getString());
                    continue;
                }
                if ("userAssignedIdentities".equals(fieldName)) {
                    Map userAssignedIdentities;
                    deserializedBatchPoolIdentity.userAssignedIdentities = userAssignedIdentities = reader.readMap(reader1 -> UserAssignedIdentities.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBatchPoolIdentity;
        });
    }
}

