/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.CertificateFormat;
import java.io.IOException;

public class CertificateBaseProperties
implements JsonSerializable<CertificateBaseProperties> {
    private String thumbprintAlgorithm;
    private String thumbprint;
    private CertificateFormat format;

    public String thumbprintAlgorithm() {
        return this.thumbprintAlgorithm;
    }

    public CertificateBaseProperties withThumbprintAlgorithm(String thumbprintAlgorithm) {
        this.thumbprintAlgorithm = thumbprintAlgorithm;
        return this;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    public CertificateBaseProperties withThumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
        return this;
    }

    public CertificateFormat format() {
        return this.format;
    }

    public CertificateBaseProperties withFormat(CertificateFormat format) {
        this.format = format;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("thumbprintAlgorithm", this.thumbprintAlgorithm);
        jsonWriter.writeStringField("thumbprint", this.thumbprint);
        jsonWriter.writeStringField("format", this.format == null ? null : this.format.toString());
        return jsonWriter.writeEndObject();
    }

    public static CertificateBaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateBaseProperties)jsonReader.readObject(reader -> {
            CertificateBaseProperties deserializedCertificateBaseProperties = new CertificateBaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("thumbprintAlgorithm".equals(fieldName)) {
                    deserializedCertificateBaseProperties.thumbprintAlgorithm = reader.getString();
                    continue;
                }
                if ("thumbprint".equals(fieldName)) {
                    deserializedCertificateBaseProperties.thumbprint = reader.getString();
                    continue;
                }
                if ("format".equals(fieldName)) {
                    deserializedCertificateBaseProperties.format = CertificateFormat.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificateBaseProperties;
        });
    }
}

