/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.fluent.models.CertificateCreateOrUpdateProperties;
import com.azure.resourcemanager.batch.models.AzureProxyResource;
import com.azure.resourcemanager.batch.models.CertificateFormat;
import java.io.IOException;
import java.util.Map;

public final class CertificateCreateOrUpdateParameters
extends AzureProxyResource {
    private CertificateCreateOrUpdateProperties innerProperties;
    private String etag;
    private String type;
    private String name;
    private String id;

    private CertificateCreateOrUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String etag() {
        return this.etag;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public CertificateCreateOrUpdateParameters withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String data() {
        return this.innerProperties() == null ? null : this.innerProperties().data();
    }

    public CertificateCreateOrUpdateParameters withData(String data) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateCreateOrUpdateProperties();
        }
        this.innerProperties().withData(data);
        return this;
    }

    public String password() {
        return this.innerProperties() == null ? null : this.innerProperties().password();
    }

    public CertificateCreateOrUpdateParameters withPassword(String password) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateCreateOrUpdateProperties();
        }
        this.innerProperties().withPassword(password);
        return this;
    }

    public String thumbprintAlgorithm() {
        return this.innerProperties() == null ? null : this.innerProperties().thumbprintAlgorithm();
    }

    public CertificateCreateOrUpdateParameters withThumbprintAlgorithm(String thumbprintAlgorithm) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateCreateOrUpdateProperties();
        }
        this.innerProperties().withThumbprintAlgorithm(thumbprintAlgorithm);
        return this;
    }

    public String thumbprint() {
        return this.innerProperties() == null ? null : this.innerProperties().thumbprint();
    }

    public CertificateCreateOrUpdateParameters withThumbprint(String thumbprint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateCreateOrUpdateProperties();
        }
        this.innerProperties().withThumbprint(thumbprint);
        return this;
    }

    public CertificateFormat format() {
        return this.innerProperties() == null ? null : this.innerProperties().format();
    }

    public CertificateCreateOrUpdateParameters withFormat(CertificateFormat format) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateCreateOrUpdateProperties();
        }
        this.innerProperties().withFormat(format);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static CertificateCreateOrUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateCreateOrUpdateParameters)((Object)jsonReader.readObject(reader -> {
            CertificateCreateOrUpdateParameters deserializedCertificateCreateOrUpdateParameters = new CertificateCreateOrUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCertificateCreateOrUpdateParameters.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCertificateCreateOrUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCertificateCreateOrUpdateParameters.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedCertificateCreateOrUpdateParameters.etag = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedCertificateCreateOrUpdateParameters.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCertificateCreateOrUpdateParameters.innerProperties = CertificateCreateOrUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificateCreateOrUpdateParameters;
        }));
    }
}

