/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.CertificateStoreLocation;
import com.azure.resourcemanager.batch.models.CertificateVisibility;
import java.io.IOException;
import java.util.List;

public final class CertificateReference
implements JsonSerializable<CertificateReference> {
    private String id;
    private CertificateStoreLocation storeLocation;
    private String storeName;
    private List<CertificateVisibility> visibility;
    private static final ClientLogger LOGGER = new ClientLogger(CertificateReference.class);

    public String id() {
        return this.id;
    }

    public CertificateReference withId(String id) {
        this.id = id;
        return this;
    }

    public CertificateStoreLocation storeLocation() {
        return this.storeLocation;
    }

    public CertificateReference withStoreLocation(CertificateStoreLocation storeLocation) {
        this.storeLocation = storeLocation;
        return this;
    }

    public String storeName() {
        return this.storeName;
    }

    public CertificateReference withStoreName(String storeName) {
        this.storeName = storeName;
        return this;
    }

    public List<CertificateVisibility> visibility() {
        return this.visibility;
    }

    public CertificateReference withVisibility(List<CertificateVisibility> visibility) {
        this.visibility = visibility;
        return this;
    }

    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property id in model CertificateReference"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("storeLocation", this.storeLocation == null ? null : this.storeLocation.toString());
        jsonWriter.writeStringField("storeName", this.storeName);
        jsonWriter.writeArrayField("visibility", this.visibility, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static CertificateReference fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateReference)jsonReader.readObject(reader -> {
            CertificateReference deserializedCertificateReference = new CertificateReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCertificateReference.id = reader.getString();
                    continue;
                }
                if ("storeLocation".equals(fieldName)) {
                    deserializedCertificateReference.storeLocation = CertificateStoreLocation.fromString(reader.getString());
                    continue;
                }
                if ("storeName".equals(fieldName)) {
                    deserializedCertificateReference.storeName = reader.getString();
                    continue;
                }
                if ("visibility".equals(fieldName)) {
                    List visibility;
                    deserializedCertificateReference.visibility = visibility = reader.readArray(reader1 -> CertificateVisibility.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificateReference;
        });
    }
}

