/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class CifsMountConfiguration
implements JsonSerializable<CifsMountConfiguration> {
    private String username;
    private String source;
    private String relativeMountPath;
    private String mountOptions;
    private String password;
    private static final ClientLogger LOGGER = new ClientLogger(CifsMountConfiguration.class);

    public String username() {
        return this.username;
    }

    public CifsMountConfiguration withUsername(String username) {
        this.username = username;
        return this;
    }

    public String source() {
        return this.source;
    }

    public CifsMountConfiguration withSource(String source) {
        this.source = source;
        return this;
    }

    public String relativeMountPath() {
        return this.relativeMountPath;
    }

    public CifsMountConfiguration withRelativeMountPath(String relativeMountPath) {
        this.relativeMountPath = relativeMountPath;
        return this;
    }

    public String mountOptions() {
        return this.mountOptions;
    }

    public CifsMountConfiguration withMountOptions(String mountOptions) {
        this.mountOptions = mountOptions;
        return this;
    }

    public String password() {
        return this.password;
    }

    public CifsMountConfiguration withPassword(String password) {
        this.password = password;
        return this;
    }

    public void validate() {
        if (this.username() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property username in model CifsMountConfiguration"));
        }
        if (this.source() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property source in model CifsMountConfiguration"));
        }
        if (this.relativeMountPath() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property relativeMountPath in model CifsMountConfiguration"));
        }
        if (this.password() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property password in model CifsMountConfiguration"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("userName", this.username);
        jsonWriter.writeStringField("source", this.source);
        jsonWriter.writeStringField("relativeMountPath", this.relativeMountPath);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("mountOptions", this.mountOptions);
        return jsonWriter.writeEndObject();
    }

    public static CifsMountConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (CifsMountConfiguration)jsonReader.readObject(reader -> {
            CifsMountConfiguration deserializedCifsMountConfiguration = new CifsMountConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("userName".equals(fieldName)) {
                    deserializedCifsMountConfiguration.username = reader.getString();
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedCifsMountConfiguration.source = reader.getString();
                    continue;
                }
                if ("relativeMountPath".equals(fieldName)) {
                    deserializedCifsMountConfiguration.relativeMountPath = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedCifsMountConfiguration.password = reader.getString();
                    continue;
                }
                if ("mountOptions".equals(fieldName)) {
                    deserializedCifsMountConfiguration.mountOptions = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCifsMountConfiguration;
        });
    }
}

