/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.ContainerRegistry;
import com.azure.resourcemanager.batch.models.ContainerType;
import java.io.IOException;
import java.util.List;

public final class ContainerConfiguration
implements JsonSerializable<ContainerConfiguration> {
    private ContainerType type;
    private List<String> containerImageNames;
    private List<ContainerRegistry> containerRegistries;
    private static final ClientLogger LOGGER = new ClientLogger(ContainerConfiguration.class);

    public ContainerType type() {
        return this.type;
    }

    public ContainerConfiguration withType(ContainerType type) {
        this.type = type;
        return this;
    }

    public List<String> containerImageNames() {
        return this.containerImageNames;
    }

    public ContainerConfiguration withContainerImageNames(List<String> containerImageNames) {
        this.containerImageNames = containerImageNames;
        return this;
    }

    public List<ContainerRegistry> containerRegistries() {
        return this.containerRegistries;
    }

    public ContainerConfiguration withContainerRegistries(List<ContainerRegistry> containerRegistries) {
        this.containerRegistries = containerRegistries;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model ContainerConfiguration"));
        }
        if (this.containerRegistries() != null) {
            this.containerRegistries().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("containerImageNames", this.containerImageNames, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("containerRegistries", this.containerRegistries, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ContainerConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerConfiguration)jsonReader.readObject(reader -> {
            ContainerConfiguration deserializedContainerConfiguration = new ContainerConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedContainerConfiguration.type = ContainerType.fromString(reader.getString());
                    continue;
                }
                if ("containerImageNames".equals(fieldName)) {
                    List containerImageNames;
                    deserializedContainerConfiguration.containerImageNames = containerImageNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("containerRegistries".equals(fieldName)) {
                    List containerRegistries;
                    deserializedContainerConfiguration.containerRegistries = containerRegistries = reader.readArray(reader1 -> ContainerRegistry.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerConfiguration;
        });
    }
}

