/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.ComputeNodeIdentityReference;
import java.io.IOException;

public final class ContainerRegistry
implements JsonSerializable<ContainerRegistry> {
    private String username;
    private String password;
    private String registryServer;
    private ComputeNodeIdentityReference identityReference;

    public String username() {
        return this.username;
    }

    public ContainerRegistry withUsername(String username) {
        this.username = username;
        return this;
    }

    public String password() {
        return this.password;
    }

    public ContainerRegistry withPassword(String password) {
        this.password = password;
        return this;
    }

    public String registryServer() {
        return this.registryServer;
    }

    public ContainerRegistry withRegistryServer(String registryServer) {
        this.registryServer = registryServer;
        return this;
    }

    public ComputeNodeIdentityReference identityReference() {
        return this.identityReference;
    }

    public ContainerRegistry withIdentityReference(ComputeNodeIdentityReference identityReference) {
        this.identityReference = identityReference;
        return this;
    }

    public void validate() {
        if (this.identityReference() != null) {
            this.identityReference().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("username", this.username);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("registryServer", this.registryServer);
        jsonWriter.writeJsonField("identityReference", (JsonSerializable)this.identityReference);
        return jsonWriter.writeEndObject();
    }

    public static ContainerRegistry fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerRegistry)jsonReader.readObject(reader -> {
            ContainerRegistry deserializedContainerRegistry = new ContainerRegistry();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("username".equals(fieldName)) {
                    deserializedContainerRegistry.username = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedContainerRegistry.password = reader.getString();
                    continue;
                }
                if ("registryServer".equals(fieldName)) {
                    deserializedContainerRegistry.registryServer = reader.getString();
                    continue;
                }
                if ("identityReference".equals(fieldName)) {
                    deserializedContainerRegistry.identityReference = ComputeNodeIdentityReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerRegistry;
        });
    }
}

