/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.CachingType;
import com.azure.resourcemanager.batch.models.StorageAccountType;
import java.io.IOException;

public final class DataDisk
implements JsonSerializable<DataDisk> {
    private int lun;
    private CachingType caching;
    private int diskSizeGB;
    private StorageAccountType storageAccountType;

    public int lun() {
        return this.lun;
    }

    public DataDisk withLun(int lun) {
        this.lun = lun;
        return this;
    }

    public CachingType caching() {
        return this.caching;
    }

    public DataDisk withCaching(CachingType caching) {
        this.caching = caching;
        return this;
    }

    public int diskSizeGB() {
        return this.diskSizeGB;
    }

    public DataDisk withDiskSizeGB(int diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    public StorageAccountType storageAccountType() {
        return this.storageAccountType;
    }

    public DataDisk withStorageAccountType(StorageAccountType storageAccountType) {
        this.storageAccountType = storageAccountType;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("lun", this.lun);
        jsonWriter.writeIntField("diskSizeGB", this.diskSizeGB);
        jsonWriter.writeStringField("caching", this.caching == null ? null : this.caching.toString());
        jsonWriter.writeStringField("storageAccountType", this.storageAccountType == null ? null : this.storageAccountType.toString());
        return jsonWriter.writeEndObject();
    }

    public static DataDisk fromJson(JsonReader jsonReader) throws IOException {
        return (DataDisk)jsonReader.readObject(reader -> {
            DataDisk deserializedDataDisk = new DataDisk();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lun".equals(fieldName)) {
                    deserializedDataDisk.lun = reader.getInt();
                    continue;
                }
                if ("diskSizeGB".equals(fieldName)) {
                    deserializedDataDisk.diskSizeGB = reader.getInt();
                    continue;
                }
                if ("caching".equals(fieldName)) {
                    deserializedDataDisk.caching = CachingType.fromString(reader.getString());
                    continue;
                }
                if ("storageAccountType".equals(fieldName)) {
                    deserializedDataDisk.storageAccountType = StorageAccountType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataDisk;
        });
    }
}

