/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DeleteCertificateError
implements JsonSerializable<DeleteCertificateError> {
    private String code;
    private String message;
    private String target;
    private List<DeleteCertificateError> details;
    private static final ClientLogger LOGGER = new ClientLogger(DeleteCertificateError.class);

    public String code() {
        return this.code;
    }

    public DeleteCertificateError withCode(String code) {
        this.code = code;
        return this;
    }

    public String message() {
        return this.message;
    }

    public DeleteCertificateError withMessage(String message) {
        this.message = message;
        return this;
    }

    public String target() {
        return this.target;
    }

    public DeleteCertificateError withTarget(String target) {
        this.target = target;
        return this;
    }

    public List<DeleteCertificateError> details() {
        return this.details;
    }

    public DeleteCertificateError withDetails(List<DeleteCertificateError> details) {
        this.details = details;
        return this;
    }

    public void validate() {
        if (this.code() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property code in model DeleteCertificateError"));
        }
        if (this.message() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property message in model DeleteCertificateError"));
        }
        if (this.details() != null) {
            this.details().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("target", this.target);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DeleteCertificateError fromJson(JsonReader jsonReader) throws IOException {
        return (DeleteCertificateError)jsonReader.readObject(reader -> {
            DeleteCertificateError deserializedDeleteCertificateError = new DeleteCertificateError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedDeleteCertificateError.code = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedDeleteCertificateError.message = reader.getString();
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedDeleteCertificateError.target = reader.getString();
                    continue;
                }
                if ("details".equals(fieldName)) {
                    List details;
                    deserializedDeleteCertificateError.details = details = reader.readArray(reader1 -> DeleteCertificateError.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeleteCertificateError;
        });
    }
}

