/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.KeySource;
import com.azure.resourcemanager.batch.models.KeyVaultProperties;
import java.io.IOException;

public final class EncryptionProperties
implements JsonSerializable<EncryptionProperties> {
    private KeySource keySource;
    private KeyVaultProperties keyVaultProperties;

    public KeySource keySource() {
        return this.keySource;
    }

    public EncryptionProperties withKeySource(KeySource keySource) {
        this.keySource = keySource;
        return this;
    }

    public KeyVaultProperties keyVaultProperties() {
        return this.keyVaultProperties;
    }

    public EncryptionProperties withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

    public void validate() {
        if (this.keyVaultProperties() != null) {
            this.keyVaultProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keySource", this.keySource == null ? null : this.keySource.toString());
        jsonWriter.writeJsonField("keyVaultProperties", (JsonSerializable)this.keyVaultProperties);
        return jsonWriter.writeEndObject();
    }

    public static EncryptionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (EncryptionProperties)jsonReader.readObject(reader -> {
            EncryptionProperties deserializedEncryptionProperties = new EncryptionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keySource".equals(fieldName)) {
                    deserializedEncryptionProperties.keySource = KeySource.fromString(reader.getString());
                    continue;
                }
                if ("keyVaultProperties".equals(fieldName)) {
                    deserializedEncryptionProperties.keyVaultProperties = KeyVaultProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEncryptionProperties;
        });
    }
}

