/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.EndpointAccessDefaultAction;
import com.azure.resourcemanager.batch.models.IpRule;
import java.io.IOException;
import java.util.List;

public final class EndpointAccessProfile
implements JsonSerializable<EndpointAccessProfile> {
    private EndpointAccessDefaultAction defaultAction;
    private List<IpRule> ipRules;
    private static final ClientLogger LOGGER = new ClientLogger(EndpointAccessProfile.class);

    public EndpointAccessDefaultAction defaultAction() {
        return this.defaultAction;
    }

    public EndpointAccessProfile withDefaultAction(EndpointAccessDefaultAction defaultAction) {
        this.defaultAction = defaultAction;
        return this;
    }

    public List<IpRule> ipRules() {
        return this.ipRules;
    }

    public EndpointAccessProfile withIpRules(List<IpRule> ipRules) {
        this.ipRules = ipRules;
        return this;
    }

    public void validate() {
        if (this.defaultAction() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property defaultAction in model EndpointAccessProfile"));
        }
        if (this.ipRules() != null) {
            this.ipRules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("defaultAction", this.defaultAction == null ? null : this.defaultAction.toString());
        jsonWriter.writeArrayField("ipRules", this.ipRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static EndpointAccessProfile fromJson(JsonReader jsonReader) throws IOException {
        return (EndpointAccessProfile)jsonReader.readObject(reader -> {
            EndpointAccessProfile deserializedEndpointAccessProfile = new EndpointAccessProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("defaultAction".equals(fieldName)) {
                    deserializedEndpointAccessProfile.defaultAction = EndpointAccessDefaultAction.fromString(reader.getString());
                    continue;
                }
                if ("ipRules".equals(fieldName)) {
                    List ipRules;
                    deserializedEndpointAccessProfile.ipRules = ipRules = reader.readArray(reader1 -> IpRule.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEndpointAccessProfile;
        });
    }
}

