/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class EnvironmentSetting
implements JsonSerializable<EnvironmentSetting> {
    private String name;
    private String value;
    private static final ClientLogger LOGGER = new ClientLogger(EnvironmentSetting.class);

    public String name() {
        return this.name;
    }

    public EnvironmentSetting withName(String name) {
        this.name = name;
        return this;
    }

    public String value() {
        return this.value;
    }

    public EnvironmentSetting withValue(String value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model EnvironmentSetting"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    public static EnvironmentSetting fromJson(JsonReader jsonReader) throws IOException {
        return (EnvironmentSetting)jsonReader.readObject(reader -> {
            EnvironmentSetting deserializedEnvironmentSetting = new EnvironmentSetting();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedEnvironmentSetting.name = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedEnvironmentSetting.value = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEnvironmentSetting;
        });
    }
}

