/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.ComputeNodeDeallocationOption;
import java.io.IOException;
import java.time.Duration;

public final class FixedScaleSettings
implements JsonSerializable<FixedScaleSettings> {
    private Duration resizeTimeout;
    private Integer targetDedicatedNodes;
    private Integer targetLowPriorityNodes;
    private ComputeNodeDeallocationOption nodeDeallocationOption;

    public Duration resizeTimeout() {
        return this.resizeTimeout;
    }

    public FixedScaleSettings withResizeTimeout(Duration resizeTimeout) {
        this.resizeTimeout = resizeTimeout;
        return this;
    }

    public Integer targetDedicatedNodes() {
        return this.targetDedicatedNodes;
    }

    public FixedScaleSettings withTargetDedicatedNodes(Integer targetDedicatedNodes) {
        this.targetDedicatedNodes = targetDedicatedNodes;
        return this;
    }

    public Integer targetLowPriorityNodes() {
        return this.targetLowPriorityNodes;
    }

    public FixedScaleSettings withTargetLowPriorityNodes(Integer targetLowPriorityNodes) {
        this.targetLowPriorityNodes = targetLowPriorityNodes;
        return this;
    }

    public ComputeNodeDeallocationOption nodeDeallocationOption() {
        return this.nodeDeallocationOption;
    }

    public FixedScaleSettings withNodeDeallocationOption(ComputeNodeDeallocationOption nodeDeallocationOption) {
        this.nodeDeallocationOption = nodeDeallocationOption;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resizeTimeout", CoreUtils.durationToStringWithDays((Duration)this.resizeTimeout));
        jsonWriter.writeNumberField("targetDedicatedNodes", (Number)this.targetDedicatedNodes);
        jsonWriter.writeNumberField("targetLowPriorityNodes", (Number)this.targetLowPriorityNodes);
        jsonWriter.writeStringField("nodeDeallocationOption", this.nodeDeallocationOption == null ? null : this.nodeDeallocationOption.toString());
        return jsonWriter.writeEndObject();
    }

    public static FixedScaleSettings fromJson(JsonReader jsonReader) throws IOException {
        return (FixedScaleSettings)jsonReader.readObject(reader -> {
            FixedScaleSettings deserializedFixedScaleSettings = new FixedScaleSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resizeTimeout".equals(fieldName)) {
                    deserializedFixedScaleSettings.resizeTimeout = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("targetDedicatedNodes".equals(fieldName)) {
                    deserializedFixedScaleSettings.targetDedicatedNodes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("targetLowPriorityNodes".equals(fieldName)) {
                    deserializedFixedScaleSettings.targetLowPriorityNodes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("nodeDeallocationOption".equals(fieldName)) {
                    deserializedFixedScaleSettings.nodeDeallocationOption = ComputeNodeDeallocationOption.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFixedScaleSettings;
        });
    }
}

