/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.InboundEndpointProtocol;
import com.azure.resourcemanager.batch.models.NetworkSecurityGroupRule;
import java.io.IOException;
import java.util.List;

public final class InboundNatPool
implements JsonSerializable<InboundNatPool> {
    private String name;
    private InboundEndpointProtocol protocol;
    private int backendPort;
    private int frontendPortRangeStart;
    private int frontendPortRangeEnd;
    private List<NetworkSecurityGroupRule> networkSecurityGroupRules;
    private static final ClientLogger LOGGER = new ClientLogger(InboundNatPool.class);

    public String name() {
        return this.name;
    }

    public InboundNatPool withName(String name) {
        this.name = name;
        return this;
    }

    public InboundEndpointProtocol protocol() {
        return this.protocol;
    }

    public InboundNatPool withProtocol(InboundEndpointProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public int backendPort() {
        return this.backendPort;
    }

    public InboundNatPool withBackendPort(int backendPort) {
        this.backendPort = backendPort;
        return this;
    }

    public int frontendPortRangeStart() {
        return this.frontendPortRangeStart;
    }

    public InboundNatPool withFrontendPortRangeStart(int frontendPortRangeStart) {
        this.frontendPortRangeStart = frontendPortRangeStart;
        return this;
    }

    public int frontendPortRangeEnd() {
        return this.frontendPortRangeEnd;
    }

    public InboundNatPool withFrontendPortRangeEnd(int frontendPortRangeEnd) {
        this.frontendPortRangeEnd = frontendPortRangeEnd;
        return this;
    }

    public List<NetworkSecurityGroupRule> networkSecurityGroupRules() {
        return this.networkSecurityGroupRules;
    }

    public InboundNatPool withNetworkSecurityGroupRules(List<NetworkSecurityGroupRule> networkSecurityGroupRules) {
        this.networkSecurityGroupRules = networkSecurityGroupRules;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model InboundNatPool"));
        }
        if (this.protocol() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property protocol in model InboundNatPool"));
        }
        if (this.networkSecurityGroupRules() != null) {
            this.networkSecurityGroupRules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeIntField("backendPort", this.backendPort);
        jsonWriter.writeIntField("frontendPortRangeStart", this.frontendPortRangeStart);
        jsonWriter.writeIntField("frontendPortRangeEnd", this.frontendPortRangeEnd);
        jsonWriter.writeArrayField("networkSecurityGroupRules", this.networkSecurityGroupRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static InboundNatPool fromJson(JsonReader jsonReader) throws IOException {
        return (InboundNatPool)jsonReader.readObject(reader -> {
            InboundNatPool deserializedInboundNatPool = new InboundNatPool();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedInboundNatPool.name = reader.getString();
                    continue;
                }
                if ("protocol".equals(fieldName)) {
                    deserializedInboundNatPool.protocol = InboundEndpointProtocol.fromString(reader.getString());
                    continue;
                }
                if ("backendPort".equals(fieldName)) {
                    deserializedInboundNatPool.backendPort = reader.getInt();
                    continue;
                }
                if ("frontendPortRangeStart".equals(fieldName)) {
                    deserializedInboundNatPool.frontendPortRangeStart = reader.getInt();
                    continue;
                }
                if ("frontendPortRangeEnd".equals(fieldName)) {
                    deserializedInboundNatPool.frontendPortRangeEnd = reader.getInt();
                    continue;
                }
                if ("networkSecurityGroupRules".equals(fieldName)) {
                    List networkSecurityGroupRules;
                    deserializedInboundNatPool.networkSecurityGroupRules = networkSecurityGroupRules = reader.readArray(reader1 -> NetworkSecurityGroupRule.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedInboundNatPool;
        });
    }
}

