/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.StorageAccountType;
import com.azure.resourcemanager.batch.models.VMDiskSecurityProfile;
import java.io.IOException;

public final class ManagedDisk
implements JsonSerializable<ManagedDisk> {
    private StorageAccountType storageAccountType;
    private VMDiskSecurityProfile securityProfile;

    public StorageAccountType storageAccountType() {
        return this.storageAccountType;
    }

    public ManagedDisk withStorageAccountType(StorageAccountType storageAccountType) {
        this.storageAccountType = storageAccountType;
        return this;
    }

    public VMDiskSecurityProfile securityProfile() {
        return this.securityProfile;
    }

    public ManagedDisk withSecurityProfile(VMDiskSecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    public void validate() {
        if (this.securityProfile() != null) {
            this.securityProfile().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageAccountType", this.storageAccountType == null ? null : this.storageAccountType.toString());
        jsonWriter.writeJsonField("securityProfile", (JsonSerializable)this.securityProfile);
        return jsonWriter.writeEndObject();
    }

    public static ManagedDisk fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedDisk)jsonReader.readObject(reader -> {
            ManagedDisk deserializedManagedDisk = new ManagedDisk();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageAccountType".equals(fieldName)) {
                    deserializedManagedDisk.storageAccountType = StorageAccountType.fromString(reader.getString());
                    continue;
                }
                if ("securityProfile".equals(fieldName)) {
                    deserializedManagedDisk.securityProfile = VMDiskSecurityProfile.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedDisk;
        });
    }
}

