/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.AzureBlobFileSystemConfiguration;
import com.azure.resourcemanager.batch.models.AzureFileShareConfiguration;
import com.azure.resourcemanager.batch.models.CifsMountConfiguration;
import com.azure.resourcemanager.batch.models.NfsMountConfiguration;
import java.io.IOException;

public final class MountConfiguration
implements JsonSerializable<MountConfiguration> {
    private AzureBlobFileSystemConfiguration azureBlobFileSystemConfiguration;
    private NfsMountConfiguration nfsMountConfiguration;
    private CifsMountConfiguration cifsMountConfiguration;
    private AzureFileShareConfiguration azureFileShareConfiguration;

    public AzureBlobFileSystemConfiguration azureBlobFileSystemConfiguration() {
        return this.azureBlobFileSystemConfiguration;
    }

    public MountConfiguration withAzureBlobFileSystemConfiguration(AzureBlobFileSystemConfiguration azureBlobFileSystemConfiguration) {
        this.azureBlobFileSystemConfiguration = azureBlobFileSystemConfiguration;
        return this;
    }

    public NfsMountConfiguration nfsMountConfiguration() {
        return this.nfsMountConfiguration;
    }

    public MountConfiguration withNfsMountConfiguration(NfsMountConfiguration nfsMountConfiguration) {
        this.nfsMountConfiguration = nfsMountConfiguration;
        return this;
    }

    public CifsMountConfiguration cifsMountConfiguration() {
        return this.cifsMountConfiguration;
    }

    public MountConfiguration withCifsMountConfiguration(CifsMountConfiguration cifsMountConfiguration) {
        this.cifsMountConfiguration = cifsMountConfiguration;
        return this;
    }

    public AzureFileShareConfiguration azureFileShareConfiguration() {
        return this.azureFileShareConfiguration;
    }

    public MountConfiguration withAzureFileShareConfiguration(AzureFileShareConfiguration azureFileShareConfiguration) {
        this.azureFileShareConfiguration = azureFileShareConfiguration;
        return this;
    }

    public void validate() {
        if (this.azureBlobFileSystemConfiguration() != null) {
            this.azureBlobFileSystemConfiguration().validate();
        }
        if (this.nfsMountConfiguration() != null) {
            this.nfsMountConfiguration().validate();
        }
        if (this.cifsMountConfiguration() != null) {
            this.cifsMountConfiguration().validate();
        }
        if (this.azureFileShareConfiguration() != null) {
            this.azureFileShareConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("azureBlobFileSystemConfiguration", (JsonSerializable)this.azureBlobFileSystemConfiguration);
        jsonWriter.writeJsonField("nfsMountConfiguration", (JsonSerializable)this.nfsMountConfiguration);
        jsonWriter.writeJsonField("cifsMountConfiguration", (JsonSerializable)this.cifsMountConfiguration);
        jsonWriter.writeJsonField("azureFileShareConfiguration", (JsonSerializable)this.azureFileShareConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static MountConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (MountConfiguration)jsonReader.readObject(reader -> {
            MountConfiguration deserializedMountConfiguration = new MountConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("azureBlobFileSystemConfiguration".equals(fieldName)) {
                    deserializedMountConfiguration.azureBlobFileSystemConfiguration = AzureBlobFileSystemConfiguration.fromJson(reader);
                    continue;
                }
                if ("nfsMountConfiguration".equals(fieldName)) {
                    deserializedMountConfiguration.nfsMountConfiguration = NfsMountConfiguration.fromJson(reader);
                    continue;
                }
                if ("cifsMountConfiguration".equals(fieldName)) {
                    deserializedMountConfiguration.cifsMountConfiguration = CifsMountConfiguration.fromJson(reader);
                    continue;
                }
                if ("azureFileShareConfiguration".equals(fieldName)) {
                    deserializedMountConfiguration.azureFileShareConfiguration = AzureFileShareConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMountConfiguration;
        });
    }
}

