/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.DynamicVNetAssignmentScope;
import com.azure.resourcemanager.batch.models.PoolEndpointConfiguration;
import com.azure.resourcemanager.batch.models.PublicIpAddressConfiguration;
import java.io.IOException;

public final class NetworkConfiguration
implements JsonSerializable<NetworkConfiguration> {
    private String subnetId;
    private DynamicVNetAssignmentScope dynamicVnetAssignmentScope;
    private PoolEndpointConfiguration endpointConfiguration;
    private PublicIpAddressConfiguration publicIpAddressConfiguration;
    private Boolean enableAcceleratedNetworking;

    public String subnetId() {
        return this.subnetId;
    }

    public NetworkConfiguration withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public DynamicVNetAssignmentScope dynamicVnetAssignmentScope() {
        return this.dynamicVnetAssignmentScope;
    }

    public NetworkConfiguration withDynamicVnetAssignmentScope(DynamicVNetAssignmentScope dynamicVnetAssignmentScope) {
        this.dynamicVnetAssignmentScope = dynamicVnetAssignmentScope;
        return this;
    }

    public PoolEndpointConfiguration endpointConfiguration() {
        return this.endpointConfiguration;
    }

    public NetworkConfiguration withEndpointConfiguration(PoolEndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
        return this;
    }

    public PublicIpAddressConfiguration publicIpAddressConfiguration() {
        return this.publicIpAddressConfiguration;
    }

    public NetworkConfiguration withPublicIpAddressConfiguration(PublicIpAddressConfiguration publicIpAddressConfiguration) {
        this.publicIpAddressConfiguration = publicIpAddressConfiguration;
        return this;
    }

    public Boolean enableAcceleratedNetworking() {
        return this.enableAcceleratedNetworking;
    }

    public NetworkConfiguration withEnableAcceleratedNetworking(Boolean enableAcceleratedNetworking) {
        this.enableAcceleratedNetworking = enableAcceleratedNetworking;
        return this;
    }

    public void validate() {
        if (this.endpointConfiguration() != null) {
            this.endpointConfiguration().validate();
        }
        if (this.publicIpAddressConfiguration() != null) {
            this.publicIpAddressConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("subnetId", this.subnetId);
        jsonWriter.writeStringField("dynamicVnetAssignmentScope", this.dynamicVnetAssignmentScope == null ? null : this.dynamicVnetAssignmentScope.toString());
        jsonWriter.writeJsonField("endpointConfiguration", (JsonSerializable)this.endpointConfiguration);
        jsonWriter.writeJsonField("publicIPAddressConfiguration", (JsonSerializable)this.publicIpAddressConfiguration);
        jsonWriter.writeBooleanField("enableAcceleratedNetworking", this.enableAcceleratedNetworking);
        return jsonWriter.writeEndObject();
    }

    public static NetworkConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkConfiguration)jsonReader.readObject(reader -> {
            NetworkConfiguration deserializedNetworkConfiguration = new NetworkConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subnetId".equals(fieldName)) {
                    deserializedNetworkConfiguration.subnetId = reader.getString();
                    continue;
                }
                if ("dynamicVnetAssignmentScope".equals(fieldName)) {
                    deserializedNetworkConfiguration.dynamicVnetAssignmentScope = DynamicVNetAssignmentScope.fromString(reader.getString());
                    continue;
                }
                if ("endpointConfiguration".equals(fieldName)) {
                    deserializedNetworkConfiguration.endpointConfiguration = PoolEndpointConfiguration.fromJson(reader);
                    continue;
                }
                if ("publicIPAddressConfiguration".equals(fieldName)) {
                    deserializedNetworkConfiguration.publicIpAddressConfiguration = PublicIpAddressConfiguration.fromJson(reader);
                    continue;
                }
                if ("enableAcceleratedNetworking".equals(fieldName)) {
                    deserializedNetworkConfiguration.enableAcceleratedNetworking = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkConfiguration;
        });
    }
}

