/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.EndpointAccessProfile;
import java.io.IOException;

public final class NetworkProfile
implements JsonSerializable<NetworkProfile> {
    private EndpointAccessProfile accountAccess;
    private EndpointAccessProfile nodeManagementAccess;

    public EndpointAccessProfile accountAccess() {
        return this.accountAccess;
    }

    public NetworkProfile withAccountAccess(EndpointAccessProfile accountAccess) {
        this.accountAccess = accountAccess;
        return this;
    }

    public EndpointAccessProfile nodeManagementAccess() {
        return this.nodeManagementAccess;
    }

    public NetworkProfile withNodeManagementAccess(EndpointAccessProfile nodeManagementAccess) {
        this.nodeManagementAccess = nodeManagementAccess;
        return this;
    }

    public void validate() {
        if (this.accountAccess() != null) {
            this.accountAccess().validate();
        }
        if (this.nodeManagementAccess() != null) {
            this.nodeManagementAccess().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("accountAccess", (JsonSerializable)this.accountAccess);
        jsonWriter.writeJsonField("nodeManagementAccess", (JsonSerializable)this.nodeManagementAccess);
        return jsonWriter.writeEndObject();
    }

    public static NetworkProfile fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkProfile)jsonReader.readObject(reader -> {
            NetworkProfile deserializedNetworkProfile = new NetworkProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accountAccess".equals(fieldName)) {
                    deserializedNetworkProfile.accountAccess = EndpointAccessProfile.fromJson(reader);
                    continue;
                }
                if ("nodeManagementAccess".equals(fieldName)) {
                    deserializedNetworkProfile.nodeManagementAccess = EndpointAccessProfile.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkProfile;
        });
    }
}

