/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.NetworkSecurityGroupRuleAccess;
import java.io.IOException;
import java.util.List;

public final class NetworkSecurityGroupRule
implements JsonSerializable<NetworkSecurityGroupRule> {
    private int priority;
    private NetworkSecurityGroupRuleAccess access;
    private String sourceAddressPrefix;
    private List<String> sourcePortRanges;
    private static final ClientLogger LOGGER = new ClientLogger(NetworkSecurityGroupRule.class);

    public int priority() {
        return this.priority;
    }

    public NetworkSecurityGroupRule withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public NetworkSecurityGroupRuleAccess access() {
        return this.access;
    }

    public NetworkSecurityGroupRule withAccess(NetworkSecurityGroupRuleAccess access) {
        this.access = access;
        return this;
    }

    public String sourceAddressPrefix() {
        return this.sourceAddressPrefix;
    }

    public NetworkSecurityGroupRule withSourceAddressPrefix(String sourceAddressPrefix) {
        this.sourceAddressPrefix = sourceAddressPrefix;
        return this;
    }

    public List<String> sourcePortRanges() {
        return this.sourcePortRanges;
    }

    public NetworkSecurityGroupRule withSourcePortRanges(List<String> sourcePortRanges) {
        this.sourcePortRanges = sourcePortRanges;
        return this;
    }

    public void validate() {
        if (this.access() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property access in model NetworkSecurityGroupRule"));
        }
        if (this.sourceAddressPrefix() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceAddressPrefix in model NetworkSecurityGroupRule"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("priority", this.priority);
        jsonWriter.writeStringField("access", this.access == null ? null : this.access.toString());
        jsonWriter.writeStringField("sourceAddressPrefix", this.sourceAddressPrefix);
        jsonWriter.writeArrayField("sourcePortRanges", this.sourcePortRanges, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static NetworkSecurityGroupRule fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkSecurityGroupRule)jsonReader.readObject(reader -> {
            NetworkSecurityGroupRule deserializedNetworkSecurityGroupRule = new NetworkSecurityGroupRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("priority".equals(fieldName)) {
                    deserializedNetworkSecurityGroupRule.priority = reader.getInt();
                    continue;
                }
                if ("access".equals(fieldName)) {
                    deserializedNetworkSecurityGroupRule.access = NetworkSecurityGroupRuleAccess.fromString(reader.getString());
                    continue;
                }
                if ("sourceAddressPrefix".equals(fieldName)) {
                    deserializedNetworkSecurityGroupRule.sourceAddressPrefix = reader.getString();
                    continue;
                }
                if ("sourcePortRanges".equals(fieldName)) {
                    List sourcePortRanges;
                    deserializedNetworkSecurityGroupRule.sourcePortRanges = sourcePortRanges = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkSecurityGroupRule;
        });
    }
}

