/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class NfsMountConfiguration
implements JsonSerializable<NfsMountConfiguration> {
    private String source;
    private String relativeMountPath;
    private String mountOptions;
    private static final ClientLogger LOGGER = new ClientLogger(NfsMountConfiguration.class);

    public String source() {
        return this.source;
    }

    public NfsMountConfiguration withSource(String source) {
        this.source = source;
        return this;
    }

    public String relativeMountPath() {
        return this.relativeMountPath;
    }

    public NfsMountConfiguration withRelativeMountPath(String relativeMountPath) {
        this.relativeMountPath = relativeMountPath;
        return this;
    }

    public String mountOptions() {
        return this.mountOptions;
    }

    public NfsMountConfiguration withMountOptions(String mountOptions) {
        this.mountOptions = mountOptions;
        return this;
    }

    public void validate() {
        if (this.source() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property source in model NfsMountConfiguration"));
        }
        if (this.relativeMountPath() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property relativeMountPath in model NfsMountConfiguration"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("source", this.source);
        jsonWriter.writeStringField("relativeMountPath", this.relativeMountPath);
        jsonWriter.writeStringField("mountOptions", this.mountOptions);
        return jsonWriter.writeEndObject();
    }

    public static NfsMountConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (NfsMountConfiguration)jsonReader.readObject(reader -> {
            NfsMountConfiguration deserializedNfsMountConfiguration = new NfsMountConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("source".equals(fieldName)) {
                    deserializedNfsMountConfiguration.source = reader.getString();
                    continue;
                }
                if ("relativeMountPath".equals(fieldName)) {
                    deserializedNfsMountConfiguration.relativeMountPath = reader.getString();
                    continue;
                }
                if ("mountOptions".equals(fieldName)) {
                    deserializedNfsMountConfiguration.mountOptions = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNfsMountConfiguration;
        });
    }
}

