/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.CachingType;
import com.azure.resourcemanager.batch.models.DiffDiskSettings;
import com.azure.resourcemanager.batch.models.ManagedDisk;
import java.io.IOException;

public final class OSDisk
implements JsonSerializable<OSDisk> {
    private DiffDiskSettings ephemeralOSDiskSettings;
    private CachingType caching;
    private ManagedDisk managedDisk;
    private Integer diskSizeGB;
    private Boolean writeAcceleratorEnabled;

    public DiffDiskSettings ephemeralOSDiskSettings() {
        return this.ephemeralOSDiskSettings;
    }

    public OSDisk withEphemeralOSDiskSettings(DiffDiskSettings ephemeralOSDiskSettings) {
        this.ephemeralOSDiskSettings = ephemeralOSDiskSettings;
        return this;
    }

    public CachingType caching() {
        return this.caching;
    }

    public OSDisk withCaching(CachingType caching) {
        this.caching = caching;
        return this;
    }

    public ManagedDisk managedDisk() {
        return this.managedDisk;
    }

    public OSDisk withManagedDisk(ManagedDisk managedDisk) {
        this.managedDisk = managedDisk;
        return this;
    }

    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    public OSDisk withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    public Boolean writeAcceleratorEnabled() {
        return this.writeAcceleratorEnabled;
    }

    public OSDisk withWriteAcceleratorEnabled(Boolean writeAcceleratorEnabled) {
        this.writeAcceleratorEnabled = writeAcceleratorEnabled;
        return this;
    }

    public void validate() {
        if (this.ephemeralOSDiskSettings() != null) {
            this.ephemeralOSDiskSettings().validate();
        }
        if (this.managedDisk() != null) {
            this.managedDisk().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("ephemeralOSDiskSettings", (JsonSerializable)this.ephemeralOSDiskSettings);
        jsonWriter.writeStringField("caching", this.caching == null ? null : this.caching.toString());
        jsonWriter.writeJsonField("managedDisk", (JsonSerializable)this.managedDisk);
        jsonWriter.writeNumberField("diskSizeGB", (Number)this.diskSizeGB);
        jsonWriter.writeBooleanField("writeAcceleratorEnabled", this.writeAcceleratorEnabled);
        return jsonWriter.writeEndObject();
    }

    public static OSDisk fromJson(JsonReader jsonReader) throws IOException {
        return (OSDisk)jsonReader.readObject(reader -> {
            OSDisk deserializedOSDisk = new OSDisk();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ephemeralOSDiskSettings".equals(fieldName)) {
                    deserializedOSDisk.ephemeralOSDiskSettings = DiffDiskSettings.fromJson(reader);
                    continue;
                }
                if ("caching".equals(fieldName)) {
                    deserializedOSDisk.caching = CachingType.fromString(reader.getString());
                    continue;
                }
                if ("managedDisk".equals(fieldName)) {
                    deserializedOSDisk.managedDisk = ManagedDisk.fromJson(reader);
                    continue;
                }
                if ("diskSizeGB".equals(fieldName)) {
                    deserializedOSDisk.diskSizeGB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("writeAcceleratorEnabled".equals(fieldName)) {
                    deserializedOSDisk.writeAcceleratorEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOSDisk;
        });
    }
}

