/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.InboundNatPool;
import java.io.IOException;
import java.util.List;

public final class PoolEndpointConfiguration
implements JsonSerializable<PoolEndpointConfiguration> {
    private List<InboundNatPool> inboundNatPools;
    private static final ClientLogger LOGGER = new ClientLogger(PoolEndpointConfiguration.class);

    public List<InboundNatPool> inboundNatPools() {
        return this.inboundNatPools;
    }

    public PoolEndpointConfiguration withInboundNatPools(List<InboundNatPool> inboundNatPools) {
        this.inboundNatPools = inboundNatPools;
        return this;
    }

    public void validate() {
        if (this.inboundNatPools() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property inboundNatPools in model PoolEndpointConfiguration"));
        }
        this.inboundNatPools().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("inboundNatPools", this.inboundNatPools, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static PoolEndpointConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (PoolEndpointConfiguration)jsonReader.readObject(reader -> {
            PoolEndpointConfiguration deserializedPoolEndpointConfiguration = new PoolEndpointConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("inboundNatPools".equals(fieldName)) {
                    List inboundNatPools;
                    deserializedPoolEndpointConfiguration.inboundNatPools = inboundNatPools = reader.readArray(reader1 -> InboundNatPool.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPoolEndpointConfiguration;
        });
    }
}

