/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.PrivateLinkServiceConnectionStatus;
import java.io.IOException;

public final class PrivateLinkServiceConnectionState
implements JsonSerializable<PrivateLinkServiceConnectionState> {
    private PrivateLinkServiceConnectionStatus status;
    private String description;
    private String actionsRequired;
    private static final ClientLogger LOGGER = new ClientLogger(PrivateLinkServiceConnectionState.class);

    public PrivateLinkServiceConnectionStatus status() {
        return this.status;
    }

    public PrivateLinkServiceConnectionState withStatus(PrivateLinkServiceConnectionStatus status) {
        this.status = status;
        return this;
    }

    public String description() {
        return this.description;
    }

    public PrivateLinkServiceConnectionState withDescription(String description) {
        this.description = description;
        return this;
    }

    public String actionsRequired() {
        return this.actionsRequired;
    }

    public void validate() {
        if (this.status() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property status in model PrivateLinkServiceConnectionState"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static PrivateLinkServiceConnectionState fromJson(JsonReader jsonReader) throws IOException {
        return (PrivateLinkServiceConnectionState)jsonReader.readObject(reader -> {
            PrivateLinkServiceConnectionState deserializedPrivateLinkServiceConnectionState = new PrivateLinkServiceConnectionState();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedPrivateLinkServiceConnectionState.status = PrivateLinkServiceConnectionStatus.fromString(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedPrivateLinkServiceConnectionState.description = reader.getString();
                    continue;
                }
                if ("actionsRequired".equals(fieldName)) {
                    deserializedPrivateLinkServiceConnectionState.actionsRequired = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivateLinkServiceConnectionState;
        });
    }
}

