/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.AccessRule;
import com.azure.resourcemanager.batch.models.IssueType;
import com.azure.resourcemanager.batch.models.Severity;
import java.io.IOException;
import java.util.List;

public final class ProvisioningIssueProperties
implements JsonSerializable<ProvisioningIssueProperties> {
    private IssueType issueType;
    private Severity severity;
    private String description;
    private List<String> suggestedResourceIds;
    private List<AccessRule> suggestedAccessRules;

    public IssueType issueType() {
        return this.issueType;
    }

    public Severity severity() {
        return this.severity;
    }

    public String description() {
        return this.description;
    }

    public List<String> suggestedResourceIds() {
        return this.suggestedResourceIds;
    }

    public List<AccessRule> suggestedAccessRules() {
        return this.suggestedAccessRules;
    }

    public void validate() {
        if (this.suggestedAccessRules() != null) {
            this.suggestedAccessRules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ProvisioningIssueProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ProvisioningIssueProperties)jsonReader.readObject(reader -> {
            ProvisioningIssueProperties deserializedProvisioningIssueProperties = new ProvisioningIssueProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("issueType".equals(fieldName)) {
                    deserializedProvisioningIssueProperties.issueType = IssueType.fromString(reader.getString());
                    continue;
                }
                if ("severity".equals(fieldName)) {
                    deserializedProvisioningIssueProperties.severity = Severity.fromString(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedProvisioningIssueProperties.description = reader.getString();
                    continue;
                }
                if ("suggestedResourceIds".equals(fieldName)) {
                    List suggestedResourceIds;
                    deserializedProvisioningIssueProperties.suggestedResourceIds = suggestedResourceIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("suggestedAccessRules".equals(fieldName)) {
                    List suggestedAccessRules;
                    deserializedProvisioningIssueProperties.suggestedAccessRules = suggestedAccessRules = reader.readArray(reader1 -> AccessRule.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProvisioningIssueProperties;
        });
    }
}

