/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.IpAddressProvisioningType;
import java.io.IOException;
import java.util.List;

public final class PublicIpAddressConfiguration
implements JsonSerializable<PublicIpAddressConfiguration> {
    private IpAddressProvisioningType provision;
    private List<String> ipAddressIds;

    public IpAddressProvisioningType provision() {
        return this.provision;
    }

    public PublicIpAddressConfiguration withProvision(IpAddressProvisioningType provision) {
        this.provision = provision;
        return this;
    }

    public List<String> ipAddressIds() {
        return this.ipAddressIds;
    }

    public PublicIpAddressConfiguration withIpAddressIds(List<String> ipAddressIds) {
        this.ipAddressIds = ipAddressIds;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("provision", this.provision == null ? null : this.provision.toString());
        jsonWriter.writeArrayField("ipAddressIds", this.ipAddressIds, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static PublicIpAddressConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (PublicIpAddressConfiguration)jsonReader.readObject(reader -> {
            PublicIpAddressConfiguration deserializedPublicIpAddressConfiguration = new PublicIpAddressConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provision".equals(fieldName)) {
                    deserializedPublicIpAddressConfiguration.provision = IpAddressProvisioningType.fromString(reader.getString());
                    continue;
                }
                if ("ipAddressIds".equals(fieldName)) {
                    List ipAddressIds;
                    deserializedPublicIpAddressConfiguration.ipAddressIds = ipAddressIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPublicIpAddressConfiguration;
        });
    }
}

