/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ResizeError
implements JsonSerializable<ResizeError> {
    private String code;
    private String message;
    private List<ResizeError> details;
    private static final ClientLogger LOGGER = new ClientLogger(ResizeError.class);

    public String code() {
        return this.code;
    }

    public ResizeError withCode(String code) {
        this.code = code;
        return this;
    }

    public String message() {
        return this.message;
    }

    public ResizeError withMessage(String message) {
        this.message = message;
        return this;
    }

    public List<ResizeError> details() {
        return this.details;
    }

    public ResizeError withDetails(List<ResizeError> details) {
        this.details = details;
        return this;
    }

    public void validate() {
        if (this.code() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property code in model ResizeError"));
        }
        if (this.message() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property message in model ResizeError"));
        }
        if (this.details() != null) {
            this.details().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ResizeError fromJson(JsonReader jsonReader) throws IOException {
        return (ResizeError)jsonReader.readObject(reader -> {
            ResizeError deserializedResizeError = new ResizeError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedResizeError.code = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedResizeError.message = reader.getString();
                    continue;
                }
                if ("details".equals(fieldName)) {
                    List details;
                    deserializedResizeError.details = details = reader.readArray(reader1 -> ResizeError.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResizeError;
        });
    }
}

