/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.ComputeNodeDeallocationOption;
import com.azure.resourcemanager.batch.models.ResizeError;
import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class ResizeOperationStatus
implements JsonSerializable<ResizeOperationStatus> {
    private Integer targetDedicatedNodes;
    private Integer targetLowPriorityNodes;
    private Duration resizeTimeout;
    private ComputeNodeDeallocationOption nodeDeallocationOption;
    private OffsetDateTime startTime;
    private List<ResizeError> errors;

    public Integer targetDedicatedNodes() {
        return this.targetDedicatedNodes;
    }

    public ResizeOperationStatus withTargetDedicatedNodes(Integer targetDedicatedNodes) {
        this.targetDedicatedNodes = targetDedicatedNodes;
        return this;
    }

    public Integer targetLowPriorityNodes() {
        return this.targetLowPriorityNodes;
    }

    public ResizeOperationStatus withTargetLowPriorityNodes(Integer targetLowPriorityNodes) {
        this.targetLowPriorityNodes = targetLowPriorityNodes;
        return this;
    }

    public Duration resizeTimeout() {
        return this.resizeTimeout;
    }

    public ResizeOperationStatus withResizeTimeout(Duration resizeTimeout) {
        this.resizeTimeout = resizeTimeout;
        return this;
    }

    public ComputeNodeDeallocationOption nodeDeallocationOption() {
        return this.nodeDeallocationOption;
    }

    public ResizeOperationStatus withNodeDeallocationOption(ComputeNodeDeallocationOption nodeDeallocationOption) {
        this.nodeDeallocationOption = nodeDeallocationOption;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public ResizeOperationStatus withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public List<ResizeError> errors() {
        return this.errors;
    }

    public ResizeOperationStatus withErrors(List<ResizeError> errors) {
        this.errors = errors;
        return this;
    }

    public void validate() {
        if (this.errors() != null) {
            this.errors().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("targetDedicatedNodes", (Number)this.targetDedicatedNodes);
        jsonWriter.writeNumberField("targetLowPriorityNodes", (Number)this.targetLowPriorityNodes);
        jsonWriter.writeStringField("resizeTimeout", CoreUtils.durationToStringWithDays((Duration)this.resizeTimeout));
        jsonWriter.writeStringField("nodeDeallocationOption", this.nodeDeallocationOption == null ? null : this.nodeDeallocationOption.toString());
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeArrayField("errors", this.errors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ResizeOperationStatus fromJson(JsonReader jsonReader) throws IOException {
        return (ResizeOperationStatus)jsonReader.readObject(reader -> {
            ResizeOperationStatus deserializedResizeOperationStatus = new ResizeOperationStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetDedicatedNodes".equals(fieldName)) {
                    deserializedResizeOperationStatus.targetDedicatedNodes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("targetLowPriorityNodes".equals(fieldName)) {
                    deserializedResizeOperationStatus.targetLowPriorityNodes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("resizeTimeout".equals(fieldName)) {
                    deserializedResizeOperationStatus.resizeTimeout = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("nodeDeallocationOption".equals(fieldName)) {
                    deserializedResizeOperationStatus.nodeDeallocationOption = ComputeNodeDeallocationOption.fromString(reader.getString());
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedResizeOperationStatus.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    List errors;
                    deserializedResizeOperationStatus.errors = errors = reader.readArray(reader1 -> ResizeError.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResizeOperationStatus;
        });
    }
}

