/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.ComputeNodeIdentityReference;
import java.io.IOException;

public final class ResourceFile
implements JsonSerializable<ResourceFile> {
    private String autoStorageContainerName;
    private String storageContainerUrl;
    private String httpUrl;
    private String blobPrefix;
    private String filePath;
    private String fileMode;
    private ComputeNodeIdentityReference identityReference;

    public String autoStorageContainerName() {
        return this.autoStorageContainerName;
    }

    public ResourceFile withAutoStorageContainerName(String autoStorageContainerName) {
        this.autoStorageContainerName = autoStorageContainerName;
        return this;
    }

    public String storageContainerUrl() {
        return this.storageContainerUrl;
    }

    public ResourceFile withStorageContainerUrl(String storageContainerUrl) {
        this.storageContainerUrl = storageContainerUrl;
        return this;
    }

    public String httpUrl() {
        return this.httpUrl;
    }

    public ResourceFile withHttpUrl(String httpUrl) {
        this.httpUrl = httpUrl;
        return this;
    }

    public String blobPrefix() {
        return this.blobPrefix;
    }

    public ResourceFile withBlobPrefix(String blobPrefix) {
        this.blobPrefix = blobPrefix;
        return this;
    }

    public String filePath() {
        return this.filePath;
    }

    public ResourceFile withFilePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    public String fileMode() {
        return this.fileMode;
    }

    public ResourceFile withFileMode(String fileMode) {
        this.fileMode = fileMode;
        return this;
    }

    public ComputeNodeIdentityReference identityReference() {
        return this.identityReference;
    }

    public ResourceFile withIdentityReference(ComputeNodeIdentityReference identityReference) {
        this.identityReference = identityReference;
        return this;
    }

    public void validate() {
        if (this.identityReference() != null) {
            this.identityReference().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("autoStorageContainerName", this.autoStorageContainerName);
        jsonWriter.writeStringField("storageContainerUrl", this.storageContainerUrl);
        jsonWriter.writeStringField("httpUrl", this.httpUrl);
        jsonWriter.writeStringField("blobPrefix", this.blobPrefix);
        jsonWriter.writeStringField("filePath", this.filePath);
        jsonWriter.writeStringField("fileMode", this.fileMode);
        jsonWriter.writeJsonField("identityReference", (JsonSerializable)this.identityReference);
        return jsonWriter.writeEndObject();
    }

    public static ResourceFile fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceFile)jsonReader.readObject(reader -> {
            ResourceFile deserializedResourceFile = new ResourceFile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("autoStorageContainerName".equals(fieldName)) {
                    deserializedResourceFile.autoStorageContainerName = reader.getString();
                    continue;
                }
                if ("storageContainerUrl".equals(fieldName)) {
                    deserializedResourceFile.storageContainerUrl = reader.getString();
                    continue;
                }
                if ("httpUrl".equals(fieldName)) {
                    deserializedResourceFile.httpUrl = reader.getString();
                    continue;
                }
                if ("blobPrefix".equals(fieldName)) {
                    deserializedResourceFile.blobPrefix = reader.getString();
                    continue;
                }
                if ("filePath".equals(fieldName)) {
                    deserializedResourceFile.filePath = reader.getString();
                    continue;
                }
                if ("fileMode".equals(fieldName)) {
                    deserializedResourceFile.fileMode = reader.getString();
                    continue;
                }
                if ("identityReference".equals(fieldName)) {
                    deserializedResourceFile.identityReference = ComputeNodeIdentityReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceFile;
        });
    }
}

