/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class RollingUpgradePolicy
implements JsonSerializable<RollingUpgradePolicy> {
    private Boolean enableCrossZoneUpgrade;
    private Integer maxBatchInstancePercent;
    private Integer maxUnhealthyInstancePercent;
    private Integer maxUnhealthyUpgradedInstancePercent;
    private String pauseTimeBetweenBatches;
    private Boolean prioritizeUnhealthyInstances;
    private Boolean rollbackFailedInstancesOnPolicyBreach;

    public Boolean enableCrossZoneUpgrade() {
        return this.enableCrossZoneUpgrade;
    }

    public RollingUpgradePolicy withEnableCrossZoneUpgrade(Boolean enableCrossZoneUpgrade) {
        this.enableCrossZoneUpgrade = enableCrossZoneUpgrade;
        return this;
    }

    public Integer maxBatchInstancePercent() {
        return this.maxBatchInstancePercent;
    }

    public RollingUpgradePolicy withMaxBatchInstancePercent(Integer maxBatchInstancePercent) {
        this.maxBatchInstancePercent = maxBatchInstancePercent;
        return this;
    }

    public Integer maxUnhealthyInstancePercent() {
        return this.maxUnhealthyInstancePercent;
    }

    public RollingUpgradePolicy withMaxUnhealthyInstancePercent(Integer maxUnhealthyInstancePercent) {
        this.maxUnhealthyInstancePercent = maxUnhealthyInstancePercent;
        return this;
    }

    public Integer maxUnhealthyUpgradedInstancePercent() {
        return this.maxUnhealthyUpgradedInstancePercent;
    }

    public RollingUpgradePolicy withMaxUnhealthyUpgradedInstancePercent(Integer maxUnhealthyUpgradedInstancePercent) {
        this.maxUnhealthyUpgradedInstancePercent = maxUnhealthyUpgradedInstancePercent;
        return this;
    }

    public String pauseTimeBetweenBatches() {
        return this.pauseTimeBetweenBatches;
    }

    public RollingUpgradePolicy withPauseTimeBetweenBatches(String pauseTimeBetweenBatches) {
        this.pauseTimeBetweenBatches = pauseTimeBetweenBatches;
        return this;
    }

    public Boolean prioritizeUnhealthyInstances() {
        return this.prioritizeUnhealthyInstances;
    }

    public RollingUpgradePolicy withPrioritizeUnhealthyInstances(Boolean prioritizeUnhealthyInstances) {
        this.prioritizeUnhealthyInstances = prioritizeUnhealthyInstances;
        return this;
    }

    public Boolean rollbackFailedInstancesOnPolicyBreach() {
        return this.rollbackFailedInstancesOnPolicyBreach;
    }

    public RollingUpgradePolicy withRollbackFailedInstancesOnPolicyBreach(Boolean rollbackFailedInstancesOnPolicyBreach) {
        this.rollbackFailedInstancesOnPolicyBreach = rollbackFailedInstancesOnPolicyBreach;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enableCrossZoneUpgrade", this.enableCrossZoneUpgrade);
        jsonWriter.writeNumberField("maxBatchInstancePercent", (Number)this.maxBatchInstancePercent);
        jsonWriter.writeNumberField("maxUnhealthyInstancePercent", (Number)this.maxUnhealthyInstancePercent);
        jsonWriter.writeNumberField("maxUnhealthyUpgradedInstancePercent", (Number)this.maxUnhealthyUpgradedInstancePercent);
        jsonWriter.writeStringField("pauseTimeBetweenBatches", this.pauseTimeBetweenBatches);
        jsonWriter.writeBooleanField("prioritizeUnhealthyInstances", this.prioritizeUnhealthyInstances);
        jsonWriter.writeBooleanField("rollbackFailedInstancesOnPolicyBreach", this.rollbackFailedInstancesOnPolicyBreach);
        return jsonWriter.writeEndObject();
    }

    public static RollingUpgradePolicy fromJson(JsonReader jsonReader) throws IOException {
        return (RollingUpgradePolicy)jsonReader.readObject(reader -> {
            RollingUpgradePolicy deserializedRollingUpgradePolicy = new RollingUpgradePolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enableCrossZoneUpgrade".equals(fieldName)) {
                    deserializedRollingUpgradePolicy.enableCrossZoneUpgrade = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("maxBatchInstancePercent".equals(fieldName)) {
                    deserializedRollingUpgradePolicy.maxBatchInstancePercent = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxUnhealthyInstancePercent".equals(fieldName)) {
                    deserializedRollingUpgradePolicy.maxUnhealthyInstancePercent = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxUnhealthyUpgradedInstancePercent".equals(fieldName)) {
                    deserializedRollingUpgradePolicy.maxUnhealthyUpgradedInstancePercent = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("pauseTimeBetweenBatches".equals(fieldName)) {
                    deserializedRollingUpgradePolicy.pauseTimeBetweenBatches = reader.getString();
                    continue;
                }
                if ("prioritizeUnhealthyInstances".equals(fieldName)) {
                    deserializedRollingUpgradePolicy.prioritizeUnhealthyInstances = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("rollbackFailedInstancesOnPolicyBreach".equals(fieldName)) {
                    deserializedRollingUpgradePolicy.rollbackFailedInstancesOnPolicyBreach = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRollingUpgradePolicy;
        });
    }
}

