/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.AutoScaleSettings;
import com.azure.resourcemanager.batch.models.FixedScaleSettings;
import java.io.IOException;

public final class ScaleSettings
implements JsonSerializable<ScaleSettings> {
    private FixedScaleSettings fixedScale;
    private AutoScaleSettings autoScale;

    public FixedScaleSettings fixedScale() {
        return this.fixedScale;
    }

    public ScaleSettings withFixedScale(FixedScaleSettings fixedScale) {
        this.fixedScale = fixedScale;
        return this;
    }

    public AutoScaleSettings autoScale() {
        return this.autoScale;
    }

    public ScaleSettings withAutoScale(AutoScaleSettings autoScale) {
        this.autoScale = autoScale;
        return this;
    }

    public void validate() {
        if (this.fixedScale() != null) {
            this.fixedScale().validate();
        }
        if (this.autoScale() != null) {
            this.autoScale().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("fixedScale", (JsonSerializable)this.fixedScale);
        jsonWriter.writeJsonField("autoScale", (JsonSerializable)this.autoScale);
        return jsonWriter.writeEndObject();
    }

    public static ScaleSettings fromJson(JsonReader jsonReader) throws IOException {
        return (ScaleSettings)jsonReader.readObject(reader -> {
            ScaleSettings deserializedScaleSettings = new ScaleSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("fixedScale".equals(fieldName)) {
                    deserializedScaleSettings.fixedScale = FixedScaleSettings.fromJson(reader);
                    continue;
                }
                if ("autoScale".equals(fieldName)) {
                    deserializedScaleSettings.autoScale = AutoScaleSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScaleSettings;
        });
    }
}

