/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.SecurityTypes;
import com.azure.resourcemanager.batch.models.UefiSettings;
import java.io.IOException;

public final class SecurityProfile
implements JsonSerializable<SecurityProfile> {
    private SecurityTypes securityType;
    private Boolean encryptionAtHost;
    private UefiSettings uefiSettings;

    public SecurityTypes securityType() {
        return this.securityType;
    }

    public SecurityProfile withSecurityType(SecurityTypes securityType) {
        this.securityType = securityType;
        return this;
    }

    public Boolean encryptionAtHost() {
        return this.encryptionAtHost;
    }

    public SecurityProfile withEncryptionAtHost(Boolean encryptionAtHost) {
        this.encryptionAtHost = encryptionAtHost;
        return this;
    }

    public UefiSettings uefiSettings() {
        return this.uefiSettings;
    }

    public SecurityProfile withUefiSettings(UefiSettings uefiSettings) {
        this.uefiSettings = uefiSettings;
        return this;
    }

    public void validate() {
        if (this.uefiSettings() != null) {
            this.uefiSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("securityType", this.securityType == null ? null : this.securityType.toString());
        jsonWriter.writeBooleanField("encryptionAtHost", this.encryptionAtHost);
        jsonWriter.writeJsonField("uefiSettings", (JsonSerializable)this.uefiSettings);
        return jsonWriter.writeEndObject();
    }

    public static SecurityProfile fromJson(JsonReader jsonReader) throws IOException {
        return (SecurityProfile)jsonReader.readObject(reader -> {
            SecurityProfile deserializedSecurityProfile = new SecurityProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("securityType".equals(fieldName)) {
                    deserializedSecurityProfile.securityType = SecurityTypes.fromString(reader.getString());
                    continue;
                }
                if ("encryptionAtHost".equals(fieldName)) {
                    deserializedSecurityProfile.encryptionAtHost = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("uefiSettings".equals(fieldName)) {
                    deserializedSecurityProfile.uefiSettings = UefiSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecurityProfile;
        });
    }
}

