/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.EnvironmentSetting;
import com.azure.resourcemanager.batch.models.ResourceFile;
import com.azure.resourcemanager.batch.models.TaskContainerSettings;
import com.azure.resourcemanager.batch.models.UserIdentity;
import java.io.IOException;
import java.util.List;

public final class StartTask
implements JsonSerializable<StartTask> {
    private String commandLine;
    private List<ResourceFile> resourceFiles;
    private List<EnvironmentSetting> environmentSettings;
    private UserIdentity userIdentity;
    private Integer maxTaskRetryCount;
    private Boolean waitForSuccess;
    private TaskContainerSettings containerSettings;

    public String commandLine() {
        return this.commandLine;
    }

    public StartTask withCommandLine(String commandLine) {
        this.commandLine = commandLine;
        return this;
    }

    public List<ResourceFile> resourceFiles() {
        return this.resourceFiles;
    }

    public StartTask withResourceFiles(List<ResourceFile> resourceFiles) {
        this.resourceFiles = resourceFiles;
        return this;
    }

    public List<EnvironmentSetting> environmentSettings() {
        return this.environmentSettings;
    }

    public StartTask withEnvironmentSettings(List<EnvironmentSetting> environmentSettings) {
        this.environmentSettings = environmentSettings;
        return this;
    }

    public UserIdentity userIdentity() {
        return this.userIdentity;
    }

    public StartTask withUserIdentity(UserIdentity userIdentity) {
        this.userIdentity = userIdentity;
        return this;
    }

    public Integer maxTaskRetryCount() {
        return this.maxTaskRetryCount;
    }

    public StartTask withMaxTaskRetryCount(Integer maxTaskRetryCount) {
        this.maxTaskRetryCount = maxTaskRetryCount;
        return this;
    }

    public Boolean waitForSuccess() {
        return this.waitForSuccess;
    }

    public StartTask withWaitForSuccess(Boolean waitForSuccess) {
        this.waitForSuccess = waitForSuccess;
        return this;
    }

    public TaskContainerSettings containerSettings() {
        return this.containerSettings;
    }

    public StartTask withContainerSettings(TaskContainerSettings containerSettings) {
        this.containerSettings = containerSettings;
        return this;
    }

    public void validate() {
        if (this.resourceFiles() != null) {
            this.resourceFiles().forEach(e -> e.validate());
        }
        if (this.environmentSettings() != null) {
            this.environmentSettings().forEach(e -> e.validate());
        }
        if (this.userIdentity() != null) {
            this.userIdentity().validate();
        }
        if (this.containerSettings() != null) {
            this.containerSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("commandLine", this.commandLine);
        jsonWriter.writeArrayField("resourceFiles", this.resourceFiles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("environmentSettings", this.environmentSettings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("userIdentity", (JsonSerializable)this.userIdentity);
        jsonWriter.writeNumberField("maxTaskRetryCount", (Number)this.maxTaskRetryCount);
        jsonWriter.writeBooleanField("waitForSuccess", this.waitForSuccess);
        jsonWriter.writeJsonField("containerSettings", (JsonSerializable)this.containerSettings);
        return jsonWriter.writeEndObject();
    }

    public static StartTask fromJson(JsonReader jsonReader) throws IOException {
        return (StartTask)jsonReader.readObject(reader -> {
            StartTask deserializedStartTask = new StartTask();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("commandLine".equals(fieldName)) {
                    deserializedStartTask.commandLine = reader.getString();
                    continue;
                }
                if ("resourceFiles".equals(fieldName)) {
                    List resourceFiles;
                    deserializedStartTask.resourceFiles = resourceFiles = reader.readArray(reader1 -> ResourceFile.fromJson(reader1));
                    continue;
                }
                if ("environmentSettings".equals(fieldName)) {
                    List environmentSettings;
                    deserializedStartTask.environmentSettings = environmentSettings = reader.readArray(reader1 -> EnvironmentSetting.fromJson(reader1));
                    continue;
                }
                if ("userIdentity".equals(fieldName)) {
                    deserializedStartTask.userIdentity = UserIdentity.fromJson(reader);
                    continue;
                }
                if ("maxTaskRetryCount".equals(fieldName)) {
                    deserializedStartTask.maxTaskRetryCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("waitForSuccess".equals(fieldName)) {
                    deserializedStartTask.waitForSuccess = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("containerSettings".equals(fieldName)) {
                    deserializedStartTask.containerSettings = TaskContainerSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStartTask;
        });
    }
}

