/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.fluent.models.SupportedSkuInner;
import java.io.IOException;
import java.util.List;

public final class SupportedSkusResult
implements JsonSerializable<SupportedSkusResult> {
    private List<SupportedSkuInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(SupportedSkusResult.class);

    public List<SupportedSkuInner> value() {
        return this.value;
    }

    public SupportedSkusResult withValue(List<SupportedSkuInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model SupportedSkusResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SupportedSkusResult fromJson(JsonReader jsonReader) throws IOException {
        return (SupportedSkusResult)jsonReader.readObject(reader -> {
            SupportedSkusResult deserializedSupportedSkusResult = new SupportedSkusResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedSupportedSkusResult.value = value = reader.readArray(reader1 -> SupportedSkuInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedSupportedSkusResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSupportedSkusResult;
        });
    }
}

