/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.ContainerHostBatchBindMountEntry;
import com.azure.resourcemanager.batch.models.ContainerRegistry;
import com.azure.resourcemanager.batch.models.ContainerWorkingDirectory;
import java.io.IOException;
import java.util.List;

public final class TaskContainerSettings
implements JsonSerializable<TaskContainerSettings> {
    private String containerRunOptions;
    private String imageName;
    private ContainerRegistry registry;
    private ContainerWorkingDirectory workingDirectory;
    private List<ContainerHostBatchBindMountEntry> containerHostBatchBindMounts;
    private static final ClientLogger LOGGER = new ClientLogger(TaskContainerSettings.class);

    public String containerRunOptions() {
        return this.containerRunOptions;
    }

    public TaskContainerSettings withContainerRunOptions(String containerRunOptions) {
        this.containerRunOptions = containerRunOptions;
        return this;
    }

    public String imageName() {
        return this.imageName;
    }

    public TaskContainerSettings withImageName(String imageName) {
        this.imageName = imageName;
        return this;
    }

    public ContainerRegistry registry() {
        return this.registry;
    }

    public TaskContainerSettings withRegistry(ContainerRegistry registry) {
        this.registry = registry;
        return this;
    }

    public ContainerWorkingDirectory workingDirectory() {
        return this.workingDirectory;
    }

    public TaskContainerSettings withWorkingDirectory(ContainerWorkingDirectory workingDirectory) {
        this.workingDirectory = workingDirectory;
        return this;
    }

    public List<ContainerHostBatchBindMountEntry> containerHostBatchBindMounts() {
        return this.containerHostBatchBindMounts;
    }

    public TaskContainerSettings withContainerHostBatchBindMounts(List<ContainerHostBatchBindMountEntry> containerHostBatchBindMounts) {
        this.containerHostBatchBindMounts = containerHostBatchBindMounts;
        return this;
    }

    public void validate() {
        if (this.imageName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property imageName in model TaskContainerSettings"));
        }
        if (this.registry() != null) {
            this.registry().validate();
        }
        if (this.containerHostBatchBindMounts() != null) {
            this.containerHostBatchBindMounts().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("imageName", this.imageName);
        jsonWriter.writeStringField("containerRunOptions", this.containerRunOptions);
        jsonWriter.writeJsonField("registry", (JsonSerializable)this.registry);
        jsonWriter.writeStringField("workingDirectory", this.workingDirectory == null ? null : this.workingDirectory.toString());
        jsonWriter.writeArrayField("containerHostBatchBindMounts", this.containerHostBatchBindMounts, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static TaskContainerSettings fromJson(JsonReader jsonReader) throws IOException {
        return (TaskContainerSettings)jsonReader.readObject(reader -> {
            TaskContainerSettings deserializedTaskContainerSettings = new TaskContainerSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("imageName".equals(fieldName)) {
                    deserializedTaskContainerSettings.imageName = reader.getString();
                    continue;
                }
                if ("containerRunOptions".equals(fieldName)) {
                    deserializedTaskContainerSettings.containerRunOptions = reader.getString();
                    continue;
                }
                if ("registry".equals(fieldName)) {
                    deserializedTaskContainerSettings.registry = ContainerRegistry.fromJson(reader);
                    continue;
                }
                if ("workingDirectory".equals(fieldName)) {
                    deserializedTaskContainerSettings.workingDirectory = ContainerWorkingDirectory.fromString(reader.getString());
                    continue;
                }
                if ("containerHostBatchBindMounts".equals(fieldName)) {
                    List containerHostBatchBindMounts;
                    deserializedTaskContainerSettings.containerHostBatchBindMounts = containerHostBatchBindMounts = reader.readArray(reader1 -> ContainerHostBatchBindMountEntry.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTaskContainerSettings;
        });
    }
}

