/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.ComputeNodeFillType;
import java.io.IOException;

public final class TaskSchedulingPolicy
implements JsonSerializable<TaskSchedulingPolicy> {
    private ComputeNodeFillType nodeFillType;
    private static final ClientLogger LOGGER = new ClientLogger(TaskSchedulingPolicy.class);

    public ComputeNodeFillType nodeFillType() {
        return this.nodeFillType;
    }

    public TaskSchedulingPolicy withNodeFillType(ComputeNodeFillType nodeFillType) {
        this.nodeFillType = nodeFillType;
        return this;
    }

    public void validate() {
        if (this.nodeFillType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property nodeFillType in model TaskSchedulingPolicy"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nodeFillType", this.nodeFillType == null ? null : this.nodeFillType.toString());
        return jsonWriter.writeEndObject();
    }

    public static TaskSchedulingPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (TaskSchedulingPolicy)jsonReader.readObject(reader -> {
            TaskSchedulingPolicy deserializedTaskSchedulingPolicy = new TaskSchedulingPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nodeFillType".equals(fieldName)) {
                    deserializedTaskSchedulingPolicy.nodeFillType = ComputeNodeFillType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTaskSchedulingPolicy;
        });
    }
}

