/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.AutomaticOSUpgradePolicy;
import com.azure.resourcemanager.batch.models.RollingUpgradePolicy;
import com.azure.resourcemanager.batch.models.UpgradeMode;
import java.io.IOException;

public final class UpgradePolicy
implements JsonSerializable<UpgradePolicy> {
    private UpgradeMode mode;
    private AutomaticOSUpgradePolicy automaticOSUpgradePolicy;
    private RollingUpgradePolicy rollingUpgradePolicy;
    private static final ClientLogger LOGGER = new ClientLogger(UpgradePolicy.class);

    public UpgradeMode mode() {
        return this.mode;
    }

    public UpgradePolicy withMode(UpgradeMode mode) {
        this.mode = mode;
        return this;
    }

    public AutomaticOSUpgradePolicy automaticOSUpgradePolicy() {
        return this.automaticOSUpgradePolicy;
    }

    public UpgradePolicy withAutomaticOSUpgradePolicy(AutomaticOSUpgradePolicy automaticOSUpgradePolicy) {
        this.automaticOSUpgradePolicy = automaticOSUpgradePolicy;
        return this;
    }

    public RollingUpgradePolicy rollingUpgradePolicy() {
        return this.rollingUpgradePolicy;
    }

    public UpgradePolicy withRollingUpgradePolicy(RollingUpgradePolicy rollingUpgradePolicy) {
        this.rollingUpgradePolicy = rollingUpgradePolicy;
        return this;
    }

    public void validate() {
        if (this.mode() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property mode in model UpgradePolicy"));
        }
        if (this.automaticOSUpgradePolicy() != null) {
            this.automaticOSUpgradePolicy().validate();
        }
        if (this.rollingUpgradePolicy() != null) {
            this.rollingUpgradePolicy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeJsonField("automaticOSUpgradePolicy", (JsonSerializable)this.automaticOSUpgradePolicy);
        jsonWriter.writeJsonField("rollingUpgradePolicy", (JsonSerializable)this.rollingUpgradePolicy);
        return jsonWriter.writeEndObject();
    }

    public static UpgradePolicy fromJson(JsonReader jsonReader) throws IOException {
        return (UpgradePolicy)jsonReader.readObject(reader -> {
            UpgradePolicy deserializedUpgradePolicy = new UpgradePolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("mode".equals(fieldName)) {
                    deserializedUpgradePolicy.mode = UpgradeMode.fromString(reader.getString());
                    continue;
                }
                if ("automaticOSUpgradePolicy".equals(fieldName)) {
                    deserializedUpgradePolicy.automaticOSUpgradePolicy = AutomaticOSUpgradePolicy.fromJson(reader);
                    continue;
                }
                if ("rollingUpgradePolicy".equals(fieldName)) {
                    deserializedUpgradePolicy.rollingUpgradePolicy = RollingUpgradePolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUpgradePolicy;
        });
    }
}

