/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.ElevationLevel;
import com.azure.resourcemanager.batch.models.LinuxUserConfiguration;
import com.azure.resourcemanager.batch.models.WindowsUserConfiguration;
import java.io.IOException;

public final class UserAccount
implements JsonSerializable<UserAccount> {
    private String name;
    private String password;
    private ElevationLevel elevationLevel;
    private LinuxUserConfiguration linuxUserConfiguration;
    private WindowsUserConfiguration windowsUserConfiguration;
    private static final ClientLogger LOGGER = new ClientLogger(UserAccount.class);

    public String name() {
        return this.name;
    }

    public UserAccount withName(String name) {
        this.name = name;
        return this;
    }

    public String password() {
        return this.password;
    }

    public UserAccount withPassword(String password) {
        this.password = password;
        return this;
    }

    public ElevationLevel elevationLevel() {
        return this.elevationLevel;
    }

    public UserAccount withElevationLevel(ElevationLevel elevationLevel) {
        this.elevationLevel = elevationLevel;
        return this;
    }

    public LinuxUserConfiguration linuxUserConfiguration() {
        return this.linuxUserConfiguration;
    }

    public UserAccount withLinuxUserConfiguration(LinuxUserConfiguration linuxUserConfiguration) {
        this.linuxUserConfiguration = linuxUserConfiguration;
        return this;
    }

    public WindowsUserConfiguration windowsUserConfiguration() {
        return this.windowsUserConfiguration;
    }

    public UserAccount withWindowsUserConfiguration(WindowsUserConfiguration windowsUserConfiguration) {
        this.windowsUserConfiguration = windowsUserConfiguration;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model UserAccount"));
        }
        if (this.password() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property password in model UserAccount"));
        }
        if (this.linuxUserConfiguration() != null) {
            this.linuxUserConfiguration().validate();
        }
        if (this.windowsUserConfiguration() != null) {
            this.windowsUserConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("elevationLevel", this.elevationLevel == null ? null : this.elevationLevel.toString());
        jsonWriter.writeJsonField("linuxUserConfiguration", (JsonSerializable)this.linuxUserConfiguration);
        jsonWriter.writeJsonField("windowsUserConfiguration", (JsonSerializable)this.windowsUserConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static UserAccount fromJson(JsonReader jsonReader) throws IOException {
        return (UserAccount)jsonReader.readObject(reader -> {
            UserAccount deserializedUserAccount = new UserAccount();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedUserAccount.name = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedUserAccount.password = reader.getString();
                    continue;
                }
                if ("elevationLevel".equals(fieldName)) {
                    deserializedUserAccount.elevationLevel = ElevationLevel.fromString(reader.getString());
                    continue;
                }
                if ("linuxUserConfiguration".equals(fieldName)) {
                    deserializedUserAccount.linuxUserConfiguration = LinuxUserConfiguration.fromJson(reader);
                    continue;
                }
                if ("windowsUserConfiguration".equals(fieldName)) {
                    deserializedUserAccount.windowsUserConfiguration = WindowsUserConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUserAccount;
        });
    }
}

