/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.AutoUserSpecification;
import java.io.IOException;

public final class UserIdentity
implements JsonSerializable<UserIdentity> {
    private String username;
    private AutoUserSpecification autoUser;

    public String username() {
        return this.username;
    }

    public UserIdentity withUsername(String username) {
        this.username = username;
        return this;
    }

    public AutoUserSpecification autoUser() {
        return this.autoUser;
    }

    public UserIdentity withAutoUser(AutoUserSpecification autoUser) {
        this.autoUser = autoUser;
        return this;
    }

    public void validate() {
        if (this.autoUser() != null) {
            this.autoUser().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("userName", this.username);
        jsonWriter.writeJsonField("autoUser", (JsonSerializable)this.autoUser);
        return jsonWriter.writeEndObject();
    }

    public static UserIdentity fromJson(JsonReader jsonReader) throws IOException {
        return (UserIdentity)jsonReader.readObject(reader -> {
            UserIdentity deserializedUserIdentity = new UserIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("userName".equals(fieldName)) {
                    deserializedUserIdentity.username = reader.getString();
                    continue;
                }
                if ("autoUser".equals(fieldName)) {
                    deserializedUserIdentity.autoUser = AutoUserSpecification.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUserIdentity;
        });
    }
}

