/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class VMExtension
implements JsonSerializable<VMExtension> {
    private String name;
    private String publisher;
    private String type;
    private String typeHandlerVersion;
    private Boolean autoUpgradeMinorVersion;
    private Boolean enableAutomaticUpgrade;
    private Object settings;
    private Object protectedSettings;
    private List<String> provisionAfterExtensions;
    private static final ClientLogger LOGGER = new ClientLogger(VMExtension.class);

    public String name() {
        return this.name;
    }

    public VMExtension withName(String name) {
        this.name = name;
        return this;
    }

    public String publisher() {
        return this.publisher;
    }

    public VMExtension withPublisher(String publisher) {
        this.publisher = publisher;
        return this;
    }

    public String type() {
        return this.type;
    }

    public VMExtension withType(String type) {
        this.type = type;
        return this;
    }

    public String typeHandlerVersion() {
        return this.typeHandlerVersion;
    }

    public VMExtension withTypeHandlerVersion(String typeHandlerVersion) {
        this.typeHandlerVersion = typeHandlerVersion;
        return this;
    }

    public Boolean autoUpgradeMinorVersion() {
        return this.autoUpgradeMinorVersion;
    }

    public VMExtension withAutoUpgradeMinorVersion(Boolean autoUpgradeMinorVersion) {
        this.autoUpgradeMinorVersion = autoUpgradeMinorVersion;
        return this;
    }

    public Boolean enableAutomaticUpgrade() {
        return this.enableAutomaticUpgrade;
    }

    public VMExtension withEnableAutomaticUpgrade(Boolean enableAutomaticUpgrade) {
        this.enableAutomaticUpgrade = enableAutomaticUpgrade;
        return this;
    }

    public Object settings() {
        return this.settings;
    }

    public VMExtension withSettings(Object settings) {
        this.settings = settings;
        return this;
    }

    public Object protectedSettings() {
        return this.protectedSettings;
    }

    public VMExtension withProtectedSettings(Object protectedSettings) {
        this.protectedSettings = protectedSettings;
        return this;
    }

    public List<String> provisionAfterExtensions() {
        return this.provisionAfterExtensions;
    }

    public VMExtension withProvisionAfterExtensions(List<String> provisionAfterExtensions) {
        this.provisionAfterExtensions = provisionAfterExtensions;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model VMExtension"));
        }
        if (this.publisher() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property publisher in model VMExtension"));
        }
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model VMExtension"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("publisher", this.publisher);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("typeHandlerVersion", this.typeHandlerVersion);
        jsonWriter.writeBooleanField("autoUpgradeMinorVersion", this.autoUpgradeMinorVersion);
        jsonWriter.writeBooleanField("enableAutomaticUpgrade", this.enableAutomaticUpgrade);
        jsonWriter.writeUntypedField("settings", this.settings);
        jsonWriter.writeUntypedField("protectedSettings", this.protectedSettings);
        jsonWriter.writeArrayField("provisionAfterExtensions", this.provisionAfterExtensions, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static VMExtension fromJson(JsonReader jsonReader) throws IOException {
        return (VMExtension)jsonReader.readObject(reader -> {
            VMExtension deserializedVMExtension = new VMExtension();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedVMExtension.name = reader.getString();
                    continue;
                }
                if ("publisher".equals(fieldName)) {
                    deserializedVMExtension.publisher = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVMExtension.type = reader.getString();
                    continue;
                }
                if ("typeHandlerVersion".equals(fieldName)) {
                    deserializedVMExtension.typeHandlerVersion = reader.getString();
                    continue;
                }
                if ("autoUpgradeMinorVersion".equals(fieldName)) {
                    deserializedVMExtension.autoUpgradeMinorVersion = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableAutomaticUpgrade".equals(fieldName)) {
                    deserializedVMExtension.enableAutomaticUpgrade = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("settings".equals(fieldName)) {
                    deserializedVMExtension.settings = reader.readUntyped();
                    continue;
                }
                if ("protectedSettings".equals(fieldName)) {
                    deserializedVMExtension.protectedSettings = reader.readUntyped();
                    continue;
                }
                if ("provisionAfterExtensions".equals(fieldName)) {
                    List provisionAfterExtensions;
                    deserializedVMExtension.provisionAfterExtensions = provisionAfterExtensions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVMExtension;
        });
    }
}

