/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.batch.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.ContainerConfiguration;
import com.azure.resourcemanager.batch.models.DataDisk;
import com.azure.resourcemanager.batch.models.DiskEncryptionConfiguration;
import com.azure.resourcemanager.batch.models.ImageReference;
import com.azure.resourcemanager.batch.models.NodePlacementConfiguration;
import com.azure.resourcemanager.batch.models.OSDisk;
import com.azure.resourcemanager.batch.models.SecurityProfile;
import com.azure.resourcemanager.batch.models.ServiceArtifactReference;
import com.azure.resourcemanager.batch.models.VMExtension;
import com.azure.resourcemanager.batch.models.WindowsConfiguration;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineConfiguration
implements JsonSerializable<VirtualMachineConfiguration> {
    private ImageReference imageReference;
    private String nodeAgentSkuId;
    private WindowsConfiguration windowsConfiguration;
    private List<DataDisk> dataDisks;
    private String licenseType;
    private ContainerConfiguration containerConfiguration;
    private DiskEncryptionConfiguration diskEncryptionConfiguration;
    private NodePlacementConfiguration nodePlacementConfiguration;
    private List<VMExtension> extensions;
    private OSDisk osDisk;
    private SecurityProfile securityProfile;
    private ServiceArtifactReference serviceArtifactReference;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineConfiguration.class);

    public ImageReference imageReference() {
        return this.imageReference;
    }

    public VirtualMachineConfiguration withImageReference(ImageReference imageReference) {
        this.imageReference = imageReference;
        return this;
    }

    public String nodeAgentSkuId() {
        return this.nodeAgentSkuId;
    }

    public VirtualMachineConfiguration withNodeAgentSkuId(String nodeAgentSkuId) {
        this.nodeAgentSkuId = nodeAgentSkuId;
        return this;
    }

    public WindowsConfiguration windowsConfiguration() {
        return this.windowsConfiguration;
    }

    public VirtualMachineConfiguration withWindowsConfiguration(WindowsConfiguration windowsConfiguration) {
        this.windowsConfiguration = windowsConfiguration;
        return this;
    }

    public List<DataDisk> dataDisks() {
        return this.dataDisks;
    }

    public VirtualMachineConfiguration withDataDisks(List<DataDisk> dataDisks) {
        this.dataDisks = dataDisks;
        return this;
    }

    public String licenseType() {
        return this.licenseType;
    }

    public VirtualMachineConfiguration withLicenseType(String licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public ContainerConfiguration containerConfiguration() {
        return this.containerConfiguration;
    }

    public VirtualMachineConfiguration withContainerConfiguration(ContainerConfiguration containerConfiguration) {
        this.containerConfiguration = containerConfiguration;
        return this;
    }

    public DiskEncryptionConfiguration diskEncryptionConfiguration() {
        return this.diskEncryptionConfiguration;
    }

    public VirtualMachineConfiguration withDiskEncryptionConfiguration(DiskEncryptionConfiguration diskEncryptionConfiguration) {
        this.diskEncryptionConfiguration = diskEncryptionConfiguration;
        return this;
    }

    public NodePlacementConfiguration nodePlacementConfiguration() {
        return this.nodePlacementConfiguration;
    }

    public VirtualMachineConfiguration withNodePlacementConfiguration(NodePlacementConfiguration nodePlacementConfiguration) {
        this.nodePlacementConfiguration = nodePlacementConfiguration;
        return this;
    }

    public List<VMExtension> extensions() {
        return this.extensions;
    }

    public VirtualMachineConfiguration withExtensions(List<VMExtension> extensions) {
        this.extensions = extensions;
        return this;
    }

    public OSDisk osDisk() {
        return this.osDisk;
    }

    public VirtualMachineConfiguration withOsDisk(OSDisk osDisk) {
        this.osDisk = osDisk;
        return this;
    }

    public SecurityProfile securityProfile() {
        return this.securityProfile;
    }

    public VirtualMachineConfiguration withSecurityProfile(SecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    public ServiceArtifactReference serviceArtifactReference() {
        return this.serviceArtifactReference;
    }

    public VirtualMachineConfiguration withServiceArtifactReference(ServiceArtifactReference serviceArtifactReference) {
        this.serviceArtifactReference = serviceArtifactReference;
        return this;
    }

    public void validate() {
        if (this.imageReference() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property imageReference in model VirtualMachineConfiguration"));
        }
        this.imageReference().validate();
        if (this.nodeAgentSkuId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property nodeAgentSkuId in model VirtualMachineConfiguration"));
        }
        if (this.windowsConfiguration() != null) {
            this.windowsConfiguration().validate();
        }
        if (this.dataDisks() != null) {
            this.dataDisks().forEach(e -> e.validate());
        }
        if (this.containerConfiguration() != null) {
            this.containerConfiguration().validate();
        }
        if (this.diskEncryptionConfiguration() != null) {
            this.diskEncryptionConfiguration().validate();
        }
        if (this.nodePlacementConfiguration() != null) {
            this.nodePlacementConfiguration().validate();
        }
        if (this.extensions() != null) {
            this.extensions().forEach(e -> e.validate());
        }
        if (this.osDisk() != null) {
            this.osDisk().validate();
        }
        if (this.securityProfile() != null) {
            this.securityProfile().validate();
        }
        if (this.serviceArtifactReference() != null) {
            this.serviceArtifactReference().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("imageReference", (JsonSerializable)this.imageReference);
        jsonWriter.writeStringField("nodeAgentSkuId", this.nodeAgentSkuId);
        jsonWriter.writeJsonField("windowsConfiguration", (JsonSerializable)this.windowsConfiguration);
        jsonWriter.writeArrayField("dataDisks", this.dataDisks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("licenseType", this.licenseType);
        jsonWriter.writeJsonField("containerConfiguration", (JsonSerializable)this.containerConfiguration);
        jsonWriter.writeJsonField("diskEncryptionConfiguration", (JsonSerializable)this.diskEncryptionConfiguration);
        jsonWriter.writeJsonField("nodePlacementConfiguration", (JsonSerializable)this.nodePlacementConfiguration);
        jsonWriter.writeArrayField("extensions", this.extensions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("osDisk", (JsonSerializable)this.osDisk);
        jsonWriter.writeJsonField("securityProfile", (JsonSerializable)this.securityProfile);
        jsonWriter.writeJsonField("serviceArtifactReference", (JsonSerializable)this.serviceArtifactReference);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineConfiguration)jsonReader.readObject(reader -> {
            VirtualMachineConfiguration deserializedVirtualMachineConfiguration = new VirtualMachineConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("imageReference".equals(fieldName)) {
                    deserializedVirtualMachineConfiguration.imageReference = ImageReference.fromJson(reader);
                    continue;
                }
                if ("nodeAgentSkuId".equals(fieldName)) {
                    deserializedVirtualMachineConfiguration.nodeAgentSkuId = reader.getString();
                    continue;
                }
                if ("windowsConfiguration".equals(fieldName)) {
                    deserializedVirtualMachineConfiguration.windowsConfiguration = WindowsConfiguration.fromJson(reader);
                    continue;
                }
                if ("dataDisks".equals(fieldName)) {
                    List dataDisks;
                    deserializedVirtualMachineConfiguration.dataDisks = dataDisks = reader.readArray(reader1 -> DataDisk.fromJson(reader1));
                    continue;
                }
                if ("licenseType".equals(fieldName)) {
                    deserializedVirtualMachineConfiguration.licenseType = reader.getString();
                    continue;
                }
                if ("containerConfiguration".equals(fieldName)) {
                    deserializedVirtualMachineConfiguration.containerConfiguration = ContainerConfiguration.fromJson(reader);
                    continue;
                }
                if ("diskEncryptionConfiguration".equals(fieldName)) {
                    deserializedVirtualMachineConfiguration.diskEncryptionConfiguration = DiskEncryptionConfiguration.fromJson(reader);
                    continue;
                }
                if ("nodePlacementConfiguration".equals(fieldName)) {
                    deserializedVirtualMachineConfiguration.nodePlacementConfiguration = NodePlacementConfiguration.fromJson(reader);
                    continue;
                }
                if ("extensions".equals(fieldName)) {
                    List extensions;
                    deserializedVirtualMachineConfiguration.extensions = extensions = reader.readArray(reader1 -> VMExtension.fromJson(reader1));
                    continue;
                }
                if ("osDisk".equals(fieldName)) {
                    deserializedVirtualMachineConfiguration.osDisk = OSDisk.fromJson(reader);
                    continue;
                }
                if ("securityProfile".equals(fieldName)) {
                    deserializedVirtualMachineConfiguration.securityProfile = SecurityProfile.fromJson(reader);
                    continue;
                }
                if ("serviceArtifactReference".equals(fieldName)) {
                    deserializedVirtualMachineConfiguration.serviceArtifactReference = ServiceArtifactReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineConfiguration;
        });
    }
}

