// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.botservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The response body returned for a request to Bot Service Management to check availability of a bot name. */
@Fluent
public final class CheckNameAvailabilityResponseBodyInner {
    /*
     * indicates if the bot name is valid.
     */
    @JsonProperty(value = "valid")
    private Boolean valid;

    /*
     * additional message from the bot management api showing why a bot name is
     * not available
     */
    @JsonProperty(value = "message")
    private String message;

    /**
     * Get the valid property: indicates if the bot name is valid.
     *
     * @return the valid value.
     */
    public Boolean valid() {
        return this.valid;
    }

    /**
     * Set the valid property: indicates if the bot name is valid.
     *
     * @param valid the valid value to set.
     * @return the CheckNameAvailabilityResponseBodyInner object itself.
     */
    public CheckNameAvailabilityResponseBodyInner withValid(Boolean valid) {
        this.valid = valid;
        return this;
    }

    /**
     * Get the message property: additional message from the bot management api showing why a bot name is not available.
     *
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: additional message from the bot management api showing why a bot name is not available.
     *
     * @param message the message value to set.
     * @return the CheckNameAvailabilityResponseBodyInner object itself.
     */
    public CheckNameAvailabilityResponseBodyInner withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
