// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.botservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.botservice.models.Channel;
import com.azure.resourcemanager.botservice.models.ChannelSettings;
import com.azure.resourcemanager.botservice.models.Kind;
import com.azure.resourcemanager.botservice.models.Sku;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** The ARM channel of list channel with keys operation response. */
@Fluent
public final class ListChannelWithKeysResponseInner extends BotChannelInner {
    /*
     * The set of properties specific to bot channel resource
     */
    @JsonProperty(value = "resource")
    private Channel resource;

    /*
     * Channel settings
     */
    @JsonProperty(value = "setting")
    private ChannelSettings setting;

    /*
     * Provisioning state of the resource
     */
    @JsonProperty(value = "provisioningState")
    private String provisioningState;

    /*
     * Entity tag of the resource
     */
    @JsonProperty(value = "entityTag")
    private String entityTag;

    /*
     * Changed time of the resource
     */
    @JsonProperty(value = "changedTime")
    private String changedTime;

    /**
     * Get the resource property: The set of properties specific to bot channel resource.
     *
     * @return the resource value.
     */
    public Channel resource() {
        return this.resource;
    }

    /**
     * Set the resource property: The set of properties specific to bot channel resource.
     *
     * @param resource the resource value to set.
     * @return the ListChannelWithKeysResponseInner object itself.
     */
    public ListChannelWithKeysResponseInner withResource(Channel resource) {
        this.resource = resource;
        return this;
    }

    /**
     * Get the setting property: Channel settings.
     *
     * @return the setting value.
     */
    public ChannelSettings setting() {
        return this.setting;
    }

    /**
     * Set the setting property: Channel settings.
     *
     * @param setting the setting value to set.
     * @return the ListChannelWithKeysResponseInner object itself.
     */
    public ListChannelWithKeysResponseInner withSetting(ChannelSettings setting) {
        this.setting = setting;
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the resource.
     *
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Set the provisioningState property: Provisioning state of the resource.
     *
     * @param provisioningState the provisioningState value to set.
     * @return the ListChannelWithKeysResponseInner object itself.
     */
    public ListChannelWithKeysResponseInner withProvisioningState(String provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    /**
     * Get the entityTag property: Entity tag of the resource.
     *
     * @return the entityTag value.
     */
    public String entityTag() {
        return this.entityTag;
    }

    /**
     * Set the entityTag property: Entity tag of the resource.
     *
     * @param entityTag the entityTag value to set.
     * @return the ListChannelWithKeysResponseInner object itself.
     */
    public ListChannelWithKeysResponseInner withEntityTag(String entityTag) {
        this.entityTag = entityTag;
        return this;
    }

    /**
     * Get the changedTime property: Changed time of the resource.
     *
     * @return the changedTime value.
     */
    public String changedTime() {
        return this.changedTime;
    }

    /**
     * Set the changedTime property: Changed time of the resource.
     *
     * @param changedTime the changedTime value to set.
     * @return the ListChannelWithKeysResponseInner object itself.
     */
    public ListChannelWithKeysResponseInner withChangedTime(String changedTime) {
        this.changedTime = changedTime;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ListChannelWithKeysResponseInner withProperties(Channel properties) {
        super.withProperties(properties);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ListChannelWithKeysResponseInner withSku(Sku sku) {
        super.withSku(sku);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ListChannelWithKeysResponseInner withKind(Kind kind) {
        super.withKind(kind);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ListChannelWithKeysResponseInner withEtag(String etag) {
        super.withEtag(etag);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ListChannelWithKeysResponseInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ListChannelWithKeysResponseInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (resource() != null) {
            resource().validate();
        }
        if (setting() != null) {
            setting().validate();
        }
    }
}
