// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.botservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.botservice.models.OperationResultStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** The properties indicating the operation result of an operation on a service. */
@Immutable
public final class OperationResultsDescriptionInner {
    /*
     * The ID of the operation returned.
     */
    @JsonProperty(value = "id", access = JsonProperty.Access.WRITE_ONLY)
    private String id;

    /*
     * The name of the operation result.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * The status of the operation being performed.
     */
    @JsonProperty(value = "status", access = JsonProperty.Access.WRITE_ONLY)
    private OperationResultStatus status;

    /*
     * The time that the operation was started.
     */
    @JsonProperty(value = "startTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime startTime;

    /**
     * Get the id property: The ID of the operation returned.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the operation result.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the status property: The status of the operation being performed.
     *
     * @return the status value.
     */
    public OperationResultStatus status() {
        return this.status;
    }

    /**
     * Get the startTime property: The time that the operation was started.
     *
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
