// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.botservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.botservice.models.ServiceProvider;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The list of bot service providers response. */
@Fluent
public final class ServiceProviderResponseListInner {
    /*
     * The link used to get the next page of bot service providers.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /*
     * Gets the list of bot service providers and their properties.
     */
    @JsonProperty(value = "value", access = JsonProperty.Access.WRITE_ONLY)
    private List<ServiceProvider> value;

    /**
     * Get the nextLink property: The link used to get the next page of bot service providers.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The link used to get the next page of bot service providers.
     *
     * @param nextLink the nextLink value to set.
     * @return the ServiceProviderResponseListInner object itself.
     */
    public ServiceProviderResponseListInner withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Get the value property: Gets the list of bot service providers and their properties.
     *
     * @return the value value.
     */
    public List<ServiceProvider> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
