// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.botservice.implementation;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.botservice.fluent.models.BotInner;
import com.azure.resourcemanager.botservice.models.Bot;
import com.azure.resourcemanager.botservice.models.BotProperties;
import com.azure.resourcemanager.botservice.models.Kind;
import com.azure.resourcemanager.botservice.models.Sku;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class BotImpl implements Bot, Bot.Definition, Bot.Update {
    private BotInner innerObject;

    private final com.azure.resourcemanager.botservice.BotServiceManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String location() {
        return this.innerModel().location();
    }

    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        } else {
            return Collections.emptyMap();
        }
    }

    public BotProperties properties() {
        return this.innerModel().properties();
    }

    public Sku sku() {
        return this.innerModel().sku();
    }

    public Kind kind() {
        return this.innerModel().kind();
    }

    public String etag() {
        return this.innerModel().etag();
    }

    public List<String> zones() {
        List<String> inner = this.innerModel().zones();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public Region region() {
        return Region.fromName(this.regionName());
    }

    public String regionName() {
        return this.location();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public BotInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.botservice.BotServiceManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String resourceName;

    public BotImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    public Bot create() {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getBots()
                .createWithResponse(resourceGroupName, resourceName, this.innerModel(), Context.NONE)
                .getValue();
        return this;
    }

    public Bot create(Context context) {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getBots()
                .createWithResponse(resourceGroupName, resourceName, this.innerModel(), context)
                .getValue();
        return this;
    }

    BotImpl(String name, com.azure.resourcemanager.botservice.BotServiceManager serviceManager) {
        this.innerObject = new BotInner();
        this.serviceManager = serviceManager;
        this.resourceName = name;
    }

    public BotImpl update() {
        return this;
    }

    public Bot apply() {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getBots()
                .updateWithResponse(resourceGroupName, resourceName, this.innerModel(), Context.NONE)
                .getValue();
        return this;
    }

    public Bot apply(Context context) {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getBots()
                .updateWithResponse(resourceGroupName, resourceName, this.innerModel(), context)
                .getValue();
        return this;
    }

    BotImpl(BotInner innerObject, com.azure.resourcemanager.botservice.BotServiceManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.resourceName = Utils.getValueFromIdByName(innerObject.id(), "botServices");
    }

    public Bot refresh() {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getBots()
                .getByResourceGroupWithResponse(resourceGroupName, resourceName, Context.NONE)
                .getValue();
        return this;
    }

    public Bot refresh(Context context) {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getBots()
                .getByResourceGroupWithResponse(resourceGroupName, resourceName, context)
                .getValue();
        return this;
    }

    public BotImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    public BotImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    public BotImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags(tags);
        return this;
    }

    public BotImpl withProperties(BotProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    public BotImpl withSku(Sku sku) {
        this.innerModel().withSku(sku);
        return this;
    }

    public BotImpl withKind(Kind kind) {
        this.innerModel().withKind(kind);
        return this;
    }

    public BotImpl withEtag(String etag) {
        this.innerModel().withEtag(etag);
        return this;
    }
}
