// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.botservice.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.botservice.fluent.ChannelsClient;
import com.azure.resourcemanager.botservice.fluent.models.BotChannelInner;
import com.azure.resourcemanager.botservice.fluent.models.ListChannelWithKeysResponseInner;
import com.azure.resourcemanager.botservice.models.BotChannel;
import com.azure.resourcemanager.botservice.models.ChannelName;
import com.azure.resourcemanager.botservice.models.Channels;
import com.azure.resourcemanager.botservice.models.ListChannelWithKeysResponse;

public final class ChannelsImpl implements Channels {
    private static final ClientLogger LOGGER = new ClientLogger(ChannelsImpl.class);

    private final ChannelsClient innerClient;

    private final com.azure.resourcemanager.botservice.BotServiceManager serviceManager;

    public ChannelsImpl(
        ChannelsClient innerClient, com.azure.resourcemanager.botservice.BotServiceManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public BotChannel create(
        String resourceGroupName, String resourceName, ChannelName channelName, BotChannelInner parameters) {
        BotChannelInner inner = this.serviceClient().create(resourceGroupName, resourceName, channelName, parameters);
        if (inner != null) {
            return new BotChannelImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<BotChannel> createWithResponse(
        String resourceGroupName,
        String resourceName,
        ChannelName channelName,
        BotChannelInner parameters,
        Context context) {
        Response<BotChannelInner> inner =
            this.serviceClient().createWithResponse(resourceGroupName, resourceName, channelName, parameters, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new BotChannelImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public BotChannel update(
        String resourceGroupName, String resourceName, ChannelName channelName, BotChannelInner parameters) {
        BotChannelInner inner = this.serviceClient().update(resourceGroupName, resourceName, channelName, parameters);
        if (inner != null) {
            return new BotChannelImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<BotChannel> updateWithResponse(
        String resourceGroupName,
        String resourceName,
        ChannelName channelName,
        BotChannelInner parameters,
        Context context) {
        Response<BotChannelInner> inner =
            this.serviceClient().updateWithResponse(resourceGroupName, resourceName, channelName, parameters, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new BotChannelImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public void delete(String resourceGroupName, String resourceName, String channelName) {
        this.serviceClient().delete(resourceGroupName, resourceName, channelName);
    }

    public Response<Void> deleteWithResponse(
        String resourceGroupName, String resourceName, String channelName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, resourceName, channelName, context);
    }

    public BotChannel get(String resourceGroupName, String resourceName, String channelName) {
        BotChannelInner inner = this.serviceClient().get(resourceGroupName, resourceName, channelName);
        if (inner != null) {
            return new BotChannelImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<BotChannel> getWithResponse(
        String resourceGroupName, String resourceName, String channelName, Context context) {
        Response<BotChannelInner> inner =
            this.serviceClient().getWithResponse(resourceGroupName, resourceName, channelName, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new BotChannelImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ListChannelWithKeysResponse listWithKeys(
        String resourceGroupName, String resourceName, ChannelName channelName) {
        ListChannelWithKeysResponseInner inner =
            this.serviceClient().listWithKeys(resourceGroupName, resourceName, channelName);
        if (inner != null) {
            return new ListChannelWithKeysResponseImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<ListChannelWithKeysResponse> listWithKeysWithResponse(
        String resourceGroupName, String resourceName, ChannelName channelName, Context context) {
        Response<ListChannelWithKeysResponseInner> inner =
            this.serviceClient().listWithKeysWithResponse(resourceGroupName, resourceName, channelName, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new ListChannelWithKeysResponseImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public PagedIterable<BotChannel> listByResourceGroup(String resourceGroupName, String resourceName) {
        PagedIterable<BotChannelInner> inner =
            this.serviceClient().listByResourceGroup(resourceGroupName, resourceName);
        return Utils.mapPage(inner, inner1 -> new BotChannelImpl(inner1, this.manager()));
    }

    public PagedIterable<BotChannel> listByResourceGroup(
        String resourceGroupName, String resourceName, Context context) {
        PagedIterable<BotChannelInner> inner =
            this.serviceClient().listByResourceGroup(resourceGroupName, resourceName, context);
        return Utils.mapPage(inner, inner1 -> new BotChannelImpl(inner1, this.manager()));
    }

    private ChannelsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.botservice.BotServiceManager manager() {
        return this.serviceManager;
    }
}
