// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.botservice.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.botservice.fluent.DirectLinesClient;
import com.azure.resourcemanager.botservice.fluent.models.BotChannelInner;
import com.azure.resourcemanager.botservice.models.RegenerateKeysChannelName;
import com.azure.resourcemanager.botservice.models.SiteInfo;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in DirectLinesClient. */
public final class DirectLinesClientImpl implements DirectLinesClient {
    /** The proxy service used to perform REST calls. */
    private final DirectLinesService service;

    /** The service client containing this operation class. */
    private final AzureBotServiceImpl client;

    /**
     * Initializes an instance of DirectLinesClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    DirectLinesClientImpl(AzureBotServiceImpl client) {
        this.service =
            RestProxy.create(DirectLinesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AzureBotServiceDirectLines to be used by the proxy service to perform
     * REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "AzureBotServiceDirec")
    private interface DirectLinesService {
        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BotService"
                + "/botServices/{resourceName}/channels/{channelName}/regeneratekeys")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<BotChannelInner>> regenerateKeys(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("resourceName") String resourceName,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("channelName") RegenerateKeysChannelName channelName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SiteInfo parameters,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Regenerates secret keys and returns them for the DirectLine Channel of a particular BotService resource.
     *
     * @param resourceGroupName The name of the Bot resource group in the user subscription.
     * @param resourceName The name of the Bot resource.
     * @param channelName The name of the Channel resource for which keys are to be regenerated.
     * @param parameters The parameters to provide for the created bot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return bot channel resource definition along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<BotChannelInner>> regenerateKeysWithResponseAsync(
        String resourceGroupName, String resourceName, RegenerateKeysChannelName channelName, SiteInfo parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (channelName == null) {
            return Mono.error(new IllegalArgumentException("Parameter channelName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .regenerateKeys(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            resourceName,
                            this.client.getSubscriptionId(),
                            channelName,
                            this.client.getApiVersion(),
                            parameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Regenerates secret keys and returns them for the DirectLine Channel of a particular BotService resource.
     *
     * @param resourceGroupName The name of the Bot resource group in the user subscription.
     * @param resourceName The name of the Bot resource.
     * @param channelName The name of the Channel resource for which keys are to be regenerated.
     * @param parameters The parameters to provide for the created bot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return bot channel resource definition along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<BotChannelInner>> regenerateKeysWithResponseAsync(
        String resourceGroupName,
        String resourceName,
        RegenerateKeysChannelName channelName,
        SiteInfo parameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (channelName == null) {
            return Mono.error(new IllegalArgumentException("Parameter channelName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .regenerateKeys(
                this.client.getEndpoint(),
                resourceGroupName,
                resourceName,
                this.client.getSubscriptionId(),
                channelName,
                this.client.getApiVersion(),
                parameters,
                accept,
                context);
    }

    /**
     * Regenerates secret keys and returns them for the DirectLine Channel of a particular BotService resource.
     *
     * @param resourceGroupName The name of the Bot resource group in the user subscription.
     * @param resourceName The name of the Bot resource.
     * @param channelName The name of the Channel resource for which keys are to be regenerated.
     * @param parameters The parameters to provide for the created bot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return bot channel resource definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<BotChannelInner> regenerateKeysAsync(
        String resourceGroupName, String resourceName, RegenerateKeysChannelName channelName, SiteInfo parameters) {
        return regenerateKeysWithResponseAsync(resourceGroupName, resourceName, channelName, parameters)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Regenerates secret keys and returns them for the DirectLine Channel of a particular BotService resource.
     *
     * @param resourceGroupName The name of the Bot resource group in the user subscription.
     * @param resourceName The name of the Bot resource.
     * @param channelName The name of the Channel resource for which keys are to be regenerated.
     * @param parameters The parameters to provide for the created bot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return bot channel resource definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BotChannelInner regenerateKeys(
        String resourceGroupName, String resourceName, RegenerateKeysChannelName channelName, SiteInfo parameters) {
        return regenerateKeysAsync(resourceGroupName, resourceName, channelName, parameters).block();
    }

    /**
     * Regenerates secret keys and returns them for the DirectLine Channel of a particular BotService resource.
     *
     * @param resourceGroupName The name of the Bot resource group in the user subscription.
     * @param resourceName The name of the Bot resource.
     * @param channelName The name of the Channel resource for which keys are to be regenerated.
     * @param parameters The parameters to provide for the created bot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return bot channel resource definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BotChannelInner> regenerateKeysWithResponse(
        String resourceGroupName,
        String resourceName,
        RegenerateKeysChannelName channelName,
        SiteInfo parameters,
        Context context) {
        return regenerateKeysWithResponseAsync(resourceGroupName, resourceName, channelName, parameters, context)
            .block();
    }
}
