// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.botservice.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.botservice.fluent.DirectLinesClient;
import com.azure.resourcemanager.botservice.fluent.models.BotChannelInner;
import com.azure.resourcemanager.botservice.models.BotChannel;
import com.azure.resourcemanager.botservice.models.DirectLines;
import com.azure.resourcemanager.botservice.models.RegenerateKeysChannelName;
import com.azure.resourcemanager.botservice.models.SiteInfo;

public final class DirectLinesImpl implements DirectLines {
    private static final ClientLogger LOGGER = new ClientLogger(DirectLinesImpl.class);

    private final DirectLinesClient innerClient;

    private final com.azure.resourcemanager.botservice.BotServiceManager serviceManager;

    public DirectLinesImpl(
        DirectLinesClient innerClient, com.azure.resourcemanager.botservice.BotServiceManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public BotChannel regenerateKeys(
        String resourceGroupName, String resourceName, RegenerateKeysChannelName channelName, SiteInfo parameters) {
        BotChannelInner inner =
            this.serviceClient().regenerateKeys(resourceGroupName, resourceName, channelName, parameters);
        if (inner != null) {
            return new BotChannelImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<BotChannel> regenerateKeysWithResponse(
        String resourceGroupName,
        String resourceName,
        RegenerateKeysChannelName channelName,
        SiteInfo parameters,
        Context context) {
        Response<BotChannelInner> inner =
            this
                .serviceClient()
                .regenerateKeysWithResponse(resourceGroupName, resourceName, channelName, parameters, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new BotChannelImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    private DirectLinesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.botservice.BotServiceManager manager() {
        return this.serviceManager;
    }
}
