// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.botservice.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.botservice.fluent.HostSettingsClient;
import com.azure.resourcemanager.botservice.fluent.models.HostSettingsResponseInner;
import com.azure.resourcemanager.botservice.models.HostSettings;
import com.azure.resourcemanager.botservice.models.HostSettingsResponse;

public final class HostSettingsImpl implements HostSettings {
    private static final ClientLogger LOGGER = new ClientLogger(HostSettingsImpl.class);

    private final HostSettingsClient innerClient;

    private final com.azure.resourcemanager.botservice.BotServiceManager serviceManager;

    public HostSettingsImpl(
        HostSettingsClient innerClient, com.azure.resourcemanager.botservice.BotServiceManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public HostSettingsResponse get() {
        HostSettingsResponseInner inner = this.serviceClient().get();
        if (inner != null) {
            return new HostSettingsResponseImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<HostSettingsResponse> getWithResponse(Context context) {
        Response<HostSettingsResponseInner> inner = this.serviceClient().getWithResponse(context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new HostSettingsResponseImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    private HostSettingsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.botservice.BotServiceManager manager() {
        return this.serviceManager;
    }
}
